% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mipplot_box.R
\name{mipplot_box}
\alias{mipplot_box}
\title{Box plot from IAMC data}
\usage{
mipplot_box(
  D,
  region = levels(D$region),
  variable = levels(D$variable),
  target_year = levels(as.factor(D$period)),
  PRINT_OUT = FALSE,
  DEBUG = TRUE,
  language = "en"
)
}
\arguments{
\item{D}{A dataframe of IAMC data in tibble format to produce plots.}

\item{region}{A list of regions.}

\item{variable}{A list of variables.}

\item{target_year}{target year.}

\item{PRINT_OUT}{set TRUE to generate PDF file.}

\item{DEBUG}{set TRUE to show debug messages.}

\item{language}{A string of language. Possible values are "en", "jp",
"es", "zh-cn", "zh-tw". The default value is "en".}
}
\value{
A list of box plots.
}
\description{
The function arguments include the input dataframe,
             labels for the plot/axes/legend, and faceting dimensions
}
\examples{
\donttest{
library(dplyr)
data_subset <- ar5_db_sample_data \%>\%
filter(variable == "Emissions|CO2|Land Use") \%>\%
filter(model \%in\% c("AIM-Enduse 12.1", "GCAM 3.0", "IMAGE 2.4")) \%>\%
filter(period == 2100) \%>\% filter(region == "OECD90")
mipplot_box(data_subset)
}
}
