% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posthoc.R
\name{posthoc}
\alias{posthoc}
\title{Runs ANOVA and t-tests comparing clusters and markers in clusters}
\usage{
posthoc(processedDat, clustIDdif)
}
\arguments{
\item{processedDat}{data that has been processed using the processforanova function}

\item{clustIDdif}{ID number of the cluster to compare the others to}
}
\value{
A list of t-test results for each of the comparisons
}
\description{
Runs ANOVA and t-tests comparing clusters and markers in clusters
}
\examples{
library(mineCitrus)
data("citrus.combinedFCSSet")
data("citrus.foldClustering")
data("citrus.foldFeatureSet")
meds<-allmeds(citrus.combinedFCSSet=citrus.combinedFCSSet,
              citrus.foldClustering=citrus.foldClustering,
              citrus.foldFeatureSet=citrus.foldFeatureSet)
filteredmeds<-findclust(data=meds,clusters=c(19999,19972,19988))
meds2<-filterMarker(clustdat=filteredmeds,markers=c(2,3))
foranova<-processforanova(filtereddata=meds2)
ttests<-posthoc(processedDat=foranova,clustIDdif=19999)
}
