% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svor_exc.R
\name{svor_exc}
\alias{svor_exc}
\alias{svor_exc.default}
\alias{svor_exc.formula}
\alias{svor_exc.mi_df}
\title{Fit SVOR-EXC model to ordinal outcome data}
\usage{
\method{svor_exc}{default}(
  x,
  y,
  cost = 1,
  method = c("smo"),
  weights = NULL,
  control = list(kernel = "linear", sigma = if (is.vector(x)) 1 else 1/ncol(x), max_step
    = 500, scale = TRUE, verbose = FALSE),
  ...
)

\method{svor_exc}{formula}(formula, data, ...)

\method{svor_exc}{mi_df}(x, ...)
}
\arguments{
\item{x}{A data.frame, matrix, or similar object of covariates, where each
row represents an instance. If a \code{mi_df} object is passed, \code{y} is
automatically extracted, \code{bags} is ignored, and all other columns will be
used as predictors.}

\item{y}{A numeric, character, or factor vector of bag labels for each
instance.  Must satisfy \code{length(y) == nrow(x)}. Suggest that one of the
levels is 1, '1', or TRUE, which becomes the positive class; otherwise, a
positive class is chosen and a message will be supplied.}

\item{cost}{The cost parameter in SVM.}

\item{method}{The algorithm to use in fitting (default  \code{'smo'}).  When
\code{method = 'smo'}, the modified SMO algorithm from Chu and Keerthi (2007) is
used.}

\item{weights}{\code{NULL}, since weights are not implemented for this function.}

\item{control}{list of additional parameters passed to the method that
control computation with the following components:
\itemize{
\item \code{kernel} either a character the describes the kernel ('linear' or
'radial') or a kernel matrix at the instance level.
\item \code{sigma} argument needed for radial basis kernel.
\item \code{max_step} argument used when \code{method = 'heuristic'}. Maximum steps of
iteration for the heuristic algorithm.
\item \code{scale} argument used for all methods. A logical for whether to rescale
the input before fitting.
\item \code{verbose} argument used when \code{method = 'mip'}. Whether to message output
to the console.
}}

\item{...}{Arguments passed to or from other methods.}

\item{formula}{A formula with specification \code{y ~ x}. This argument is an
alternative to the \code{x}, \code{y} arguments, but requires the \code{data} argument.
See examples.}

\item{data}{If \code{formula} is provided, a data.frame or similar from which
formula elements will be extracted.}
}
\value{
An object of class \code{svor_exc}  The object contains at least the
following components:
\itemize{
\item \code{smo_fit}: A fit object from running the modified ordinal smo algorithm.
\item \code{call_type}: A character indicating which method \code{svor_exc()} was called
with.
\item \code{features}: The names of features used in training.
\item \code{levels}: The levels of \code{y} that are recorded for future prediction.
\item \code{cost}: The cost parameter from function inputs.
\item \code{n_step}: The total steps used in the heuristic algorithm.
\item \code{x_scale}: If \code{scale = TRUE}, the scaling parameters for new predictions.
}
}
\description{
This function fits the Support Vector Ordinal Regression with Explicit
Constraints based on the research of Chu and Keerthi (2007).
}
\section{Methods (by class)}{
\itemize{
\item \code{svor_exc(default)}: Method for data.frame-like objects

\item \code{svor_exc(formula)}: Method for passing formula

\item \code{svor_exc(mi_df)}: Method for \code{mi_df} objects, automatically handling bag
names, labels, and all covariates. Use the \code{bag_label} as \code{y} at the
instance level, then perform \code{svor_exc()} ignoring the MIL structure and
bags.

}}
\examples{
data("ordmvnorm")
x <- ordmvnorm[, 3:7]
y <- attr(ordmvnorm, "instance_label")

mdl1 <- svor_exc(x, y)
predict(mdl1, x)

}
\references{
Chu, W., & Keerthi, S. S. (2007). Support vector ordinal
regression. \emph{Neural computation}, \emph{19}(3), 792-815.
\doi{10.1162/neco.2007.19.3.792}
}
\seealso{
\code{\link[=predict.svor_exc]{predict.svor_exc()}} for prediction on new data.
}
\author{
Sean Kent
}
