% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misvm_orova.R
\name{predict.misvm_orova}
\alias{predict.misvm_orova}
\title{Predict method for \code{misvm_orova} object}
\usage{
\method{predict}{misvm_orova}(
  object,
  new_data,
  type = c("class", "raw"),
  layer = c("bag", "instance"),
  new_bags = "bag_name",
  ...
)
}
\arguments{
\item{object}{An object of class \code{misvm_orova}}

\item{new_data}{A data frame to predict from. This needs to have all of the
features that the data was originally fitted with.}

\item{type}{If \code{'class'}, return predicted values based on the highest output
of an individual model.  If \code{'raw'}, return the raw predicted scores for
each model.}

\item{layer}{If \code{'bag'}, return predictions at the bag level.  If
\code{'instance'}, return predictions at the instance level.}

\item{new_bags}{A character or character vector.  Can specify a singular
character that provides the column name for the bag names in \code{new_data}
(default \code{'bag_name'}).  Can also specify a vector of length
\code{nrow(new_data)} that has bag name for each row.}

\item{...}{Arguments passed to or from other methods.}
}
\value{
A tibble with \code{nrow(new_data)} rows.  If \code{type = 'class'}, the tibble
will have a column \code{.pred_class}.  If \code{type = 'raw'}, the tibble will have
K columns \verb{.pred_\{class_name\}} corresponding to the raw predictions of the
K models.
}
\description{
Predict method for \code{misvm_orova} object.  Predictions use the K fitted MI-SVM
models.  For class predictions, we return the class whose MI-SVM model has
the highest raw predicted score.  For raw predictions, a full matrix of
predictions is returned, with one column for each model.
}
\details{
When the object was fitted using the \code{formula} method, then the
parameters \code{new_bags} and \code{new_instances} are not necessary, as long as the
names match the original function call.
}
\examples{
data("ordmvnorm")
x <- ordmvnorm[, 3:7]
y <- ordmvnorm$bag_label
bags <- ordmvnorm$bag_name

mdl1 <- misvm_orova(x, y, bags)

# summarize predictions at the bag layer
library(dplyr)
df1 <- bind_cols(y = y, bags = bags, as.data.frame(x))
df1 \%>\%
  bind_cols(predict(mdl1, df1, new_bags = bags, type = "class")) \%>\%
  bind_cols(predict(mdl1, df1, new_bags = bags, type = "raw")) \%>\%
  select(-starts_with("V")) \%>\%
  distinct()

}
\seealso{
\code{\link[=misvm_orova]{misvm_orova()}} for fitting the \code{misvm_orova} object.
}
\author{
Sean Kent
}
