% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_models.R
\name{shuffle_group}
\alias{shuffle_group}
\title{Shuffle the rows in a column}
\usage{
shuffle_group(dat, col_name)
}
\arguments{
\item{dat}{a data frame containing \code{col_name}}

\item{col_name}{column name to shuffle}
}
\value{
\code{dat} with the rows of \code{col_name} shuffled
}
\description{
Shuffle the rows in a column
}
\examples{
\dontrun{
set.seed(123)
df <- dplyr::tibble(
  condition = c("a", "a", "b", "b"),
  AUC = c(.2, 0.3, 0.8, 0.9)
)
shuffle_group(df, "condition")
}
}
\author{
Courtney R Armour, \email{armourc@umich.edu}
}
\keyword{internal}
