% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/micvar.R
\name{verify_stability}
\alias{verify_stability}
\title{Verify stability of a vector autoregressive model}
\usage{
verify_stability(A)
}
\arguments{
\item{A}{List of coefficient matrices.}
}
\value{
None. Throws error if not stable process.
}
\description{
Stability is verified using the method the method on pages 14-17 of \insertCite{lutkepohl2005new}{micvar}. Specifically we generate the coefficient matrix for the VAR(1) representation of the process and check that all eigenvalues have modulus less than 1.
}
\examples{
VAR3_2_A <- list(gen_coef_mat(3, 0.1, 0.3, 0.8), # lag 1
                 gen_coef_mat(3, 0.1, 0.4 , 0.5)) # lag 2
verify_stability(VAR3_2_A)
}
\references{
\insertRef{lutkepohl2005new}{micvar}
}
