% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/micss.R
\name{estimate.alpha}
\alias{estimate.alpha}
\title{estimate.alpha}
\usage{
estimate.alpha(x, sig.lev = 0.05, tail.est = "Hill", k = 0.1)
}
\arguments{
\item{x}{A numeric vector.}

\item{sig.lev}{Significance level. The default value is 0.05.}

\item{tail.est}{Estimator of the tail index. The default value is "Hill", which uses Hill's (1975) estimator. "NR" uses Nicolau & Rodrigues (2019) estimator.}

\item{k}{Fraction of the upper tail to be used to estimate of the tail index. The default value is 0.1.}
}
\value{
\itemize{
  \item \code{alpha}: Value of the tail index (alpha) to be used in \link{micss}.
  \item \code{alpha.fit}: Estimated tail index.
  \item \code{t4}: Test of the null hypothesis alpha>=4 against alpha<4.
  \item \code{t2}: Test of the null hypothesis alpha<=2 against alpha>2.
}
}
\description{
Computes the estimator of the tail index (alpha) using Hill (1975) or Nicolau & Rodrigues (2019) estimators and
tests both the hypothesis that alpha is bigger or equal to 4, and that alpha is lower or equal to 2.
}
\details{
Used internally by \link{micss}.
}
\references{
B. Hill (1975): A Simple General Approach to Inference About the Tail of a Distribution. The Annals of Mathematical Statistics 3, 1163-1174.

J. Nicolau and P.M.M. Rodrigues (2019): A new regression-based tail index estimator. The Review of Economics and Statistics 101, 667-680.
}
\keyword{internal}
