% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/poisreg.R
\name{poisreg}
\alias{poisreg}
\alias{scoretest.poisreg}
\alias{residuals.poisreg}
\title{Poisson regression}
\usage{
poisreg(
  formula,
  data,
  weights,
  subset,
  na.action,
  offset,
  contrasts = NULL,
  start = NULL,
  mixing = c("none", "gamma", "lognorm"),
  vlink = c("nb1", "nb2"),
  opt = c("bfgs", "nr", "newton"),
  maxit = 100,
  trace = 0,
  check_gradient = FALSE,
  ...
)

\method{scoretest}{poisreg}(object, ..., vcov = NULL)

\method{residuals}{poisreg}(object, ..., type = c("deviance", "pearson", "response"))
}
\arguments{
\item{formula}{a symbolic description of the model, (for the count
component and for the selection equation)}

\item{data}{a data frame}

\item{subset, weights, na.action, offset, contrasts}{see \code{stats::lm},}

\item{start}{a vector of starting values}

\item{mixing}{the mixing distribution, one of \code{"none"}, \code{"gamma"}
and \code{"lognorm"}}

\item{vlink}{one of \code{"nb1"} and \code{"nb2"}}

\item{opt}{optimization method}

\item{maxit}{maximum number of iterations}

\item{trace}{printing of intermediate result}

\item{check_gradient}{if \code{TRUE} the numeric gradient and hessian
are computed and compared to the analytical gradient and
hessian}

\item{...}{further arguments}

\item{object}{a \code{poisreg} object}

\item{vcov}{the covariance matrix estimator to use for the score
test}

\item{type}{the type of residuals for the \code{residuals} method}
}
\value{
an object of class \code{c("poisreg", "micsr")}, see
\code{micsr::micsr} for further details.
}
\description{
A unified interface to perform Poisson, Negbin and log-normal Poisson models
}
\examples{
nb1 <- poisreg(trips ~ workschl + size + dist + smsa + fulltime + distnod +
               realinc + weekend + car, trips, mixing = "gamma", vlink = "nb1")
}
\keyword{models}
