% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maglm.R
\name{maglm}
\alias{maglm}
\title{Model averaging for generalized linear models}
\usage{
maglm(data, y, family, scale = TRUE, AIC.restricted = FALSE)
}
\arguments{
\item{data}{Data frame, typically of environmental variables. Rows for sites and colmuns for environmental variables.}

\item{y}{Vector of independent variables.}

\item{family}{the 'family' object used.}

\item{scale}{Whether to scale independent variables (default = TRUE)}

\item{AIC.restricted}{Whether to use AICc (TRUE) or AIC (FALSE) (default = TRUE).}
}
\value{
A list of results

\item{res.table}{data frame with "AIC", AIC of the model, "log.L", log-likelihood of the model, "delta.aic", AIC difference to the best model, "wAIC", weighted AIC to the model, "n.vars", number of variables in the model, and each term.}

\item{importance}{vector of relative importance value of each term, caluclated as as um of the weighted AIC over all of the model in whith the term aperars.}

\item{family}{the 'family' object used.}

\item{scale}{Whether to scale independent variables (default = TRUE}

\item{AIC.restricted}{Whether to use AICc (TRUE) or AIC (FALSE) (default = TRUE).}
}
\description{
Model averaging for GLM based on information theory.
}
\examples{
#load species composition and environmental data
data(capcay)
adj.sr <- capcay$adj.sr
env_sp <- capcay$env_sp

#to fit a regression model:
maglm(data = env_sp, y = "adj.sr", family = "gaussian", AIC.restricted = TRUE)
}
\references{
Dobson, A. J. (1990) An Introduction to Generalized Linear Models. London: Chapman and Hall.

Burnham, K.P. & Anderson, D.R. (2002) Model selection and multi-model inference: a practical information-theoretic approach. Springer Verlag, New York.

Nakamura, A., C. J. Burwell, C. L. Lambkin, M. Katabuchi, A. McDougall, R. J. Raven, and V. J. Neldner. (2015) The role of human disturbance in island biogeography of arthropods and plants: an information theoretic approach. Journal of Biogeography 42:1406-1417.
}
\seealso{
\code{\link{mamglm}}, \code{\link{ses.maglm}}, \code{\link{ses.mamglm}}
}
