% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_model.R
\name{fit_glm}
\alias{fit_glm}
\title{Function that fits generalized linear models}
\usage{
fit_glm(x, y, family, weights, offset, fast = TRUE)
}
\arguments{
\item{x}{a matrix of predictors with nobs observations.}

\item{y}{a vector for the outcome variable.}

\item{family}{a family function e.g. \code{stats::gaussian()}.}

\item{weights}{a numeric vector of length nobs of 'prior weights' to be used
in the fitting process. see \code{\link[stats:glm]{stats::glm()}} for details.}

\item{offset}{a numeric vector of length nobs of of a priori known component
to be included in the linear predictor during fitting.}

\item{fast}{a logical which determines how the model is fitted. The default
\code{TRUE} uses fast fitting routines (i.e. \code{\link[stats:glm]{stats::glm.fit()}}), while \code{FALSE}
uses the normal fitting routines (\code{\link[stats:glm]{stats::glm()}}) (used for the final output
of \code{mfp2}).
The difference is mainly due to the fact that normal fitting routines have
to handle data.frames, which is a lot slower than using the model matrix
and outcome vectors directly.}
}
\value{
A list with the following components:
\itemize{
\item \code{logl}: the log likelihood of the fitted model.
\item \code{coefficients}: regression coefficients.
\item \code{df}: number of parameters (degrees of freedom).
\item \code{sse}: residual sum of squares.
\item \code{fit}: the fitted model object.
}
}
\description{
Function that fits generalized linear models
}
