% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reg_B1_sma.R
\name{B1_sma}
\alias{B1_sma}
\title{Slope of standardized major axis regression (SMA).}
\usage{
B1_sma(data = NULL, obs, pred, tidy = FALSE, orientation = "PO", na.rm = TRUE)
}
\arguments{
\item{data}{(Optional) argument to call an existing data frame containing the data.}

\item{obs}{Vector with observed values (numeric).}

\item{pred}{Vector with predicted values (numeric).}

\item{tidy}{Logical operator (TRUE/FALSE) to decide the type of return. TRUE
returns a data.frame, FALSE returns a list; Default : FALSE.}

\item{orientation}{Argument of class string specifying the axis
orientation, PO for predicted vs observed, and OP for
observed vs predicted. Default is orientation = "PO".}

\item{na.rm}{Logic argument to remove rows with missing values (NA). Default is na_rm = TRUE.}
}
\value{
an object of class \code{numeric} within a \code{list} (if tidy = FALSE) or within a
\verb{data frame} (if tidy = TRUE).
}
\description{
It calculates the slope (B1) for the bivariate linear relationship
between predicted and observed values following the SMA regression.
}
\details{
SMA is a symmetric linear regression (invariant results/interpretation to axis orientation)
recommended to describe the bivariate scatter instead of OLS regression
(classic linear model, which results vary with the axis orientation).
For the formula and more details, see \href{https://adriancorrendo.github.io/metrica/articles/available_metrics_regression.html}{online-documentation}
}
\examples{
\donttest{
set.seed(1)
X <- rnorm(n = 100, mean = 0, sd = 10)
Y <- rnorm(n = 100, mean = 0, sd = 9)
B1_sma(obs = X, pred = Y)
}
}
\references{
Warton et al. (2006).
Bivariate line-fitting methods for allometry.
\emph{Biol. Rev. Camb. Philos. Soc. 81, 259–291.} \doi{10.1002/1521-4036(200203)44:2<161::AID-BIMJ161>3.0.CO;2-N}
}
