% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_TL.R
\name{compute_TL}
\alias{compute_TL}
\alias{compute_TL.metanetwork}
\title{compute trophic levels}
\usage{
compute_TL(metanetwork)

\method{compute_TL}{metanetwork}(metanetwork)
}
\arguments{
\item{metanetwork}{object of class 'metanetwork'}
}
\value{
an object of class 'metanetwork', with computed trophic levels stored as node attribute \code{TL}

\code{NULL}
}
\description{
Method to compute trophic levels using graph Laplacian using the method described in MacKay et al 2020.
}
\details{
Let \eqn{A} be the adjacency matrix of the considered network and \eqn{D} its degree diagonal matrix.
The Laplacian matrix of the symmetrised network is defined by:
\deqn{L = D - A - t(A)}
With \eqn{v = indegree(G) - outdegree(G)} the imbalance degree vector, the trophic level \eqn{x} is defined as the solution of:
\deqn{Lx = v}
For a connected network, the solution is unique up to a translation.
We then fix the minimum trophic level value at 0 thus fixing trophic levels of all others species.
Local networks may be disconnected due to sampling effect. In that case, we fix the minimum value on each connected component.
}
\examples{
library(metanetwork)
library(igraph)

#on angola dataset
data(meta_angola)
meta_angola  = compute_TL(meta_angola)
V(meta_angola$metaweb)$TL

}
\references{
MacKay, R. S., Johnson, S., & Sansom, B. (2020). How directed is a directed network?. Royal Society open science, 7(9), 201138.
}
