% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transpose_df.R
\name{transpose_df}
\alias{transpose_df}
\title{Transpose a data frame}
\usage{
transpose_df(df)
}
\arguments{
\item{df}{A data frame to be transposed.}
}
\value{
A tibble containing the transposed data.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Is an alternative to \code{\link[=t]{t()}} to transpose a data frame. The first
column of \code{df} will become column names in the transposed data.
}
\examples{
\donttest{
library(metan)
df <-
data.frame(
 GEN = c("G1", "G2", "G3","G4"),
 E1 = rnorm(4, 100, 20),
 E2 = rnorm(4, 10, 2),
 E3 = rnorm(4, 50, 5),
 E4 = rnorm(4, 1000, 150)
)
df
t(df)
transpose_df(df)
}
}
