test_that("fmt_ci(-1.96,1.96, digits = 1) -> (-2.0, 2.0)", {
  expect_equal(fmt_ci(-1.96, 1.96, digits = 1), "(-2.0,  2.0)")
  expect_equal(fmt_ci(-1.96, 1.96, digits = 2), "(-1.96,  1.96)")
  expect_equal(fmt_ci(-1.96, 1.96, digits = 3), "(-1.960,  1.960)")
  expect_equal(fmt_ci(-1.96, 1.96, digits = 4), "(-1.9600,  1.9600)")
  expect_equal(fmt_ci(-1.22, 1.92, digits = 2), "(-1.22,  1.92)")
  expect_equal(fmt_ci(-1.22, 1.99, digits = 2), "(-1.22,  1.99)")
  expect_equal(fmt_ci(-1.999, 1.999, digits = 2), "(-2.00,  2.00)")
  expect_equal(fmt_ci(-1.999, 1.999, digits = 3), "(-1.999,  1.999)")
  expect_equal(fmt_ci(-22.227, 22.979, digits = 2), "(-22.23, 22.98)")
  expect_equal(fmt_ci(-22.227, 22.979, digits = 2), "(-22.23, 22.98)")
  expect_equal(fmt_ci(-222.227, 33.979, digits = 1), "(-222.2, 34.0)")

  expect_equal(fmt_ci(-1.96, 1.96, digits = 1, width = 6), "(  -2.0,    2.0)")
  expect_equal(fmt_ci(-1.96, 1.96, digits = 2, width = 6), "( -1.96,   1.96)")
  expect_equal(fmt_ci(-345.96, 1.96, digits = 2, width = 6), "(-345.96,   1.96)")
  expect_equal(fmt_ci(-345.96, 21.96, digits = 2, width = 6), "(-345.96,  21.96)")
  expect_equal(fmt_ci(-345.96, 211.96, digits = 2, width = 6), "(-345.96, 211.96)")
})
