% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DE.Algorithm.R
\name{DE}
\alias{DE}
\title{Optimization using Differential Evolution Algorithm}
\usage{
DE(FUN, optimType = "MIN", numVar, numPopulation = 40, maxIter = 500,
  rangeVar, scalingVector = 0.8, crossOverRate = 0.5,
  strategy = "best 1")
}
\arguments{
\item{FUN}{an objective function or cost function}

\item{optimType}{a string value that represent the type of optimization.
There are two option for this arguments: \code{"MIN"} and \code{"MAX"}.
The default value is \code{"MIN"}, which the function will do minimization.
Otherwise, you can use \code{"MAX"} for maximization problem.
The default value is \code{"MIN"}.}

\item{numVar}{a positive integer to determine the number variables.}

\item{numPopulation}{a positive integer to determine the number populations. The default value is 40.}

\item{maxIter}{a positive integer to determine the maximum number of iterations. The default value is 500.}

\item{rangeVar}{a matrix (\eqn{2 \times n}) containing the range of variables,
where \eqn{n} is the number of variables, and first and second rows
are the lower bound (minimum) and upper bound (maximum) values, respectively.
If all variable have equal upper bound, you can define \code{rangeVar} as
matrix (\eqn{2 \times 1}).}

\item{scalingVector}{a positive numeric between 0 and 1 to determine scalingVector
for mutation operator. The default value is 0.8.}

\item{crossOverRate}{a positive numeric between 0 and 1 to determine crossOver probability.
The default value is 0.5.}

\item{strategy}{characters to determine mutation method. They are six methods to choose:
\itemize{
\item "classical".
\item "best 1"
\item "target to best"
\item "best 2"
\item "rand 2"
\item "rand 2 dir"
}
details of the mutation methods are on the references. The default value is "best 1".}
}
\value{
\code{Vector [v1, v2, ..., vn]} where \code{n} is number variable
        and \code{vn} is value of \code{n-th} variable.
}
\description{
This is the internal function that implements Differential Evolution
Algorithm. It is used to solve continuous optimization tasks.
Users do not need to call it directly,
but just use \code{\link{metaOpt}}.
}
\details{
This Differential Evolution algorithm based on jurnal by (Das & Suganthan, 2011).
Differential Evolution algorithm use genetic operator for optimization such as
mutation, crossover and selection.

In order to find the optimal solution, the algorithm follow the following steps.
\itemize{
\item initialize population randomly.
\item create some mutation vectors as new candidate solutions (mutation operator).
\item perform crossover operator.
\item perform selection operator.
\item If a termination criterion (a maximum number of iterations or a sufficiently good fitness) is met,
      exit the loop, else back to create some mutation vector.
}
}
\examples{
##################################
## Optimizing the step function

# define step function as objective function
step <- function(x){
    result <- sum(abs((x+0.5))^2)
    return(result)
}

## Define parameter
numVar <- 5
rangeVar <- matrix(c(-100,100), nrow=2)

## calculate the optimum solution using differential evolution
resultDE <- DE(step, optimType="MIN", numVar, numPopulation=20,
                 maxIter=100, rangeVar)

## calculate the optimum value using step function
optimum.value <- step(resultDE)

}
\references{
Das, S., & Suganthan, P. N. (2011). Differential evolution: A survey of the state-of-the-art.
IEEE transactions on evolutionary computation, 15(1), 4-31.
}
\seealso{
\code{\link{metaOpt}}
}
