% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mgcont.R
\name{mgcont}
\alias{mgcont}
\title{Group Studies with Continuous Outcome Data by Homogeneity}
\usage{
mgcont(data, n.e, mean.e, sd.e, n.c, mean.c, sd.c, studlab, ...)
}
\arguments{
\item{data}{A data frame containing the meta-analysis data.}

\item{n.e}{A vector of sample sizes in the experimental group.}

\item{mean.e}{A vector of means in the experimental group.}

\item{sd.e}{A vector of standard deviations in the experimental group.}

\item{n.c}{A vector of sample sizes in the control group.}

\item{mean.c}{A vector of means in the control group.}

\item{sd.c}{A vector of standard deviations in the control group.}

\item{studlab}{A vector of study labels.}

\item{...}{Additional arguments passed on to `meta::metacont`.}
}
\value{
A list containing the final data with subgroup assignments (`data`),
the final `metacont` model (`model`), and the number of attempts (`attempts`).
}
\description{
This function iteratively assigns studies to subgroups based on a homogeneity
test. The goal is to create statistically homogeneous groups of studies
before performing a final meta-analysis with continuous outcome data.
}
\details{
The algorithm starts with a single study in "group 1". It then processes
each subsequent study, attempting to place it in an existing group. A study
is added to a group only if its inclusion does not result in significant
within-group heterogeneity. If no suitable group is found, a new one is created.
}
\seealso{
\code{\link{meaning}}
}
\author{
Ahmed Abdelmageed \email{ahmedelsaeedmassad@gmail.com}
}
