% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metaadd.R
\name{metaadd}
\alias{metaadd}
\title{Add pooled results from external analysis to meta-analysis}
\usage{
metaadd(
  x,
  type = NULL,
  TE = NA,
  lower = NA,
  upper = NA,
  statistic = NA,
  pval = NA,
  df = NA,
  se = NA,
  method = "",
  method.ci = "",
  text = "Added result",
  data = NULL,
  transf = gs("transf")
)
}
\arguments{
\item{x}{Meta-analysis object.}

\item{type}{A character string or vector indicating whether added
results are from common effect, random effects model or
prediction interval. Either \code{"common"}, \code{"random"},
\code{"prediction"}, or \code{"tau2"} can be abbreviated.}

\item{TE}{Pooled estimate(s) or between-study variance.}

\item{lower}{Lower limit(s) of confidence or prediction interval.}

\item{upper}{Upper limit(s) of confidence or prediction interval.}

\item{statistic}{Test statistic(s).}

\item{pval}{P-value(s).}

\item{df}{Degrees of freedom for confidence or prediction intervals.s}

\item{se}{Standard error(s).}

\item{method}{A character string or vector to describe the
method used to get the pooled estimate(s), prediction interval(s) or
between-study variance(s).}

\item{method.ci}{A character string or vector to describe the
method used to get the confidence or prediction interval.}

\item{text}{A character string or vector used in printouts and
forest plot to label the added results.}

\item{data}{An optional data frame containing the new results or an
object of class \code{meta}.}

\item{transf}{A logical indicating whether inputs for arguments
\code{TE}, \code{lower} and \code{upper} are already
appropriately transformed to conduct the meta-analysis or on the
original scale. If \code{transf = TRUE} (default), inputs are
expected to be log odds ratios instead of odds ratios for
\code{sm = "OR"} and Fisher's z transformed correlations instead
of correlations for \code{sm = "ZCOR"}, for example.}
}
\value{
An object of class \code{"meta"} with corresponding generic
functions (see \code{\link{meta-object}}).
}
\description{
Add pooled results from external analysis to an existing
meta-analysis object. This is useful, for example, to add results
from a Bayesian meta-analysis which is not implemented in R package
\bold{meta}.
}
\details{
In R package \bold{meta}, objects of class \code{"meta"} contain
results of both common effect and random effects
meta-analyses. This function enables the user to add the pooled
results of an additional analysis to an existing meta-analysis
object. This is useful, for example, to add the result of a
Bayesian meta-analysis.

If argument \code{data} is a meta-analysis object created with R
package \bold{meta}, arguments \code{TE}, \code{lower},
\code{upper}, \code{statistic} and \code{pval} are ignored as this
information is extracted from the meta-analysis.

Otherwise, arguments \code{TE}, \code{lower} and \code{upper} have
to be provided if \code{type = "common"} or \code{type =
"random"}. For \code{type = "prediction"}, only arguments
\code{lower} and \code{upper} are mandatory.

Note, R function \code{\link{metamerge}} can be used to add
meta-analysis results of another meta-analysis object (see
\code{\link{meta-object}}).
}
\examples{
data(Fleiss1993bin)

# Common effect and random effects meta-analysis
m1 <- metabin(d.asp, n.asp, d.plac, n.plac, data = Fleiss1993bin,
  studlab = paste(study, year), sm = "OR")

# Naive pooling
m2 <- metabin(sum(d.asp), sum(n.asp), sum(d.plac), sum(n.plac),
  data = Fleiss1993bin, sm = "OR", text.common = "Naive pooling")

# Add results of second meta-analysis from common effect model
m12 <- metaadd(m1, data = m2)
m12

forest(m12)

}
\seealso{
\code{\link{metagen}}, \code{\link{metamerge}}
}
\author{
Guido Schwarzer \email{guido.schwarzer@uniklinik-freiburg.de}
}
