// Generated by rstantools.  Do not edit by hand.

/*
    metaBMA-dev-rstantools is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    metaBMA-dev-rstantools is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with metaBMA-dev-rstantools.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#ifndef USE_STANC3
#define USE_STANC3
#endif
#include <rstan/rstaninc.hpp>
// Code generated by stanc v2.26.1-4-gd72b68b7-dirty
#include <stan/model/model_header.hpp>
namespace model_random_jzs_dstudy_namespace {
inline void validate_positive_index(const char* var_name, const char* expr,
                                    int val) {
  if (val < 1) {
    std::stringstream msg;
    msg << "Found dimension size less than one in simplex declaration"
        << "; variable=" << var_name << "; dimension size expression=" << expr
        << "; expression value=" << val;
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
inline void validate_unit_vector_index(const char* var_name, const char* expr,
                                       int val) {
  if (val <= 1) {
    std::stringstream msg;
    if (val == 1) {
      msg << "Found dimension size one in unit vector declaration."
          << " One-dimensional unit vector is discrete"
          << " but the target distribution must be continuous."
          << " variable=" << var_name << "; dimension size expression=" << expr;
    } else {
      msg << "Found dimension size less than one in unit vector declaration"
          << "; variable=" << var_name << "; dimension size expression=" << expr
          << "; expression value=" << val;
    }
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using std::pow;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::model_base_crtp;
using stan::model::rvalue;
using stan::model::cons_list;
using stan::model::index_uni;
using stan::model::index_max;
using stan::model::index_min;
using stan::model::index_min_max;
using stan::model::index_multi;
using stan::model::index_omni;
using stan::model::nil_index_list;
using namespace stan::math;
using stan::math::pow; 
stan::math::profile_map profiles__;
static int current_statement__= 0;
static const std::vector<string> locations_array__ = {" (found before start of program)",
                                                      " (in 'string', line 132, column 0 to column 39)",
                                                      " (in 'string', line 134, column 0 to column 45)",
                                                      " (in 'string', line 136, column 0 to column 20)",
                                                      " (in 'string', line 137, column 0 to column 21)",
                                                      " (in 'string', line 138, column 2 to column 18)",
                                                      " (in 'string', line 141, column 2 to column 19)",
                                                      " (in 'string', line 142, column 2 to column 38)",
                                                      " (in 'string', line 146, column 0 to column 18)",
                                                      " (in 'string', line 156, column 2 to column 52)",
                                                      " (in 'string', line 155, column 26 to line 157, column 1)",
                                                      " (in 'string', line 155, column 7 to line 157, column 1)",
                                                      " (in 'string', line 154, column 2 to column 56)",
                                                      " (in 'string', line 153, column 26 to line 155, column 1)",
                                                      " (in 'string', line 153, column 7 to line 157, column 1)",
                                                      " (in 'string', line 152, column 2 to column 87)",
                                                      " (in 'string', line 151, column 26 to line 153, column 1)",
                                                      " (in 'string', line 151, column 7 to line 157, column 1)",
                                                      " (in 'string', line 150, column 2 to column 68)",
                                                      " (in 'string', line 149, column 26 to line 151, column 1)",
                                                      " (in 'string', line 149, column 7 to line 157, column 1)",
                                                      " (in 'string', line 148, column 2 to column 53)",
                                                      " (in 'string', line 147, column 18 to line 149, column 1)",
                                                      " (in 'string', line 147, column 0 to line 157, column 1)",
                                                      " (in 'string', line 159, column 0 to column 20)",
                                                      " (in 'string', line 169, column 2 to column 58)",
                                                      " (in 'string', line 168, column 28 to line 170, column 1)",
                                                      " (in 'string', line 168, column 7 to line 170, column 1)",
                                                      " (in 'string', line 167, column 2 to column 62)",
                                                      " (in 'string', line 166, column 28 to line 168, column 1)",
                                                      " (in 'string', line 166, column 7 to line 170, column 1)",
                                                      " (in 'string', line 165, column 2 to column 99)",
                                                      " (in 'string', line 164, column 28 to line 166, column 1)",
                                                      " (in 'string', line 164, column 7 to line 170, column 1)",
                                                      " (in 'string', line 163, column 2 to column 76)",
                                                      " (in 'string', line 162, column 28 to line 164, column 1)",
                                                      " (in 'string', line 162, column 7 to line 170, column 1)",
                                                      " (in 'string', line 161, column 2 to column 59)",
                                                      " (in 'string', line 160, column 20 to line 162, column 1)",
                                                      " (in 'string', line 160, column 0 to line 170, column 1)",
                                                      " (in 'string', line 174, column 2 to column 56)",
                                                      " (in 'string', line 175, column 2 to line 177, column 72)",
                                                      " (in 'string', line 173, column 14 to line 178, column 1)",
                                                      " (in 'string', line 173, column 0 to line 178, column 1)",
                                                      " (in 'string', line 179, column 2 to column 38)",
                                                      " (in 'string', line 180, column 2 to column 40)",
                                                      " (in 'string', line 18, column 0 to column 15)",
                                                      " (in 'string', line 19, column 7 to column 8)",
                                                      " (in 'string', line 19, column 0 to column 12)",
                                                      " (in 'string', line 20, column 16 to column 17)",
                                                      " (in 'string', line 20, column 0 to column 22)",
                                                      " (in 'string', line 22, column 0 to column 15)",
                                                      " (in 'string', line 23, column 6 to column 7)",
                                                      " (in 'string', line 23, column 0 to column 24)",
                                                      " (in 'string', line 24, column 6 to column 7)",
                                                      " (in 'string', line 24, column 0 to column 43)",
                                                      " (in 'string', line 26, column 16 to column 17)",
                                                      " (in 'string', line 26, column 0 to column 26)",
                                                      " (in 'string', line 27, column 7 to column 8)",
                                                      " (in 'string', line 27, column 9 to column 15)",
                                                      " (in 'string', line 27, column 0 to column 19)",
                                                      " (in 'string', line 28, column 6 to column 7)",
                                                      " (in 'string', line 28, column 16 to column 22)",
                                                      " (in 'string', line 28, column 23 to column 29)",
                                                      " (in 'string', line 28, column 0 to column 33)",
                                                      " (in 'string', line 30, column 0 to column 22)",
                                                      " (in 'string', line 31, column 0 to column 18)",
                                                      " (in 'string', line 32, column 0 to column 17)",
                                                      " (in 'string', line 34, column 0 to column 26)",
                                                      " (in 'string', line 35, column 0 to column 20)",
                                                      " (in 'string', line 36, column 0 to column 19)",
                                                      " (in 'string', line 39, column 2 to column 19)",
                                                      " (in 'string', line 40, column 2 to column 21)",
                                                      " (in 'string', line 42, column 7 to column 8)",
                                                      " (in 'string', line 42, column 0 to column 14)",
                                                      " (in 'string', line 45, column 4 to column 21)",
                                                      " (in 'string', line 44, column 2 to line 45, column 21)",
                                                      " (in 'string', line 43, column 10 to line 46, column 1)",
                                                      " (in 'string', line 43, column 0 to line 46, column 1)",
                                                      " (in 'string', line 84, column 4 to line 85, column 76)",
                                                      " (in 'string', line 83, column 9 to line 86, column 3)",
                                                      " (in 'string', line 82, column 4 to column 16)",
                                                      " (in 'string', line 81, column 40 to line 83, column 3)",
                                                      " (in 'string', line 81, column 2 to line 86, column 3)",
                                                      " (in 'string', line 80, column 26 to line 87, column 1)",
                                                      " (in 'string', line 80, column 7 to line 87, column 1)",
                                                      " (in 'string', line 76, column 4 to line 77, column 80)",
                                                      " (in 'string', line 75, column 9 to line 78, column 3)",
                                                      " (in 'string', line 74, column 4 to column 16)",
                                                      " (in 'string', line 73, column 40 to line 75, column 3)",
                                                      " (in 'string', line 73, column 2 to line 78, column 3)",
                                                      " (in 'string', line 72, column 26 to line 80, column 1)",
                                                      " (in 'string', line 72, column 7 to line 87, column 1)",
                                                      " (in 'string', line 69, column 4 to column 41)",
                                                      " (in 'string', line 68, column 9 to line 70, column 3)",
                                                      " (in 'string', line 67, column 4 to column 16)",
                                                      " (in 'string', line 66, column 37 to line 68, column 3)",
                                                      " (in 'string', line 66, column 2 to line 70, column 3)",
                                                      " (in 'string', line 65, column 26 to line 72, column 1)",
                                                      " (in 'string', line 65, column 7 to line 87, column 1)",
                                                      " (in 'string', line 61, column 4 to line 62, column 92)",
                                                      " (in 'string', line 60, column 9 to line 63, column 3)",
                                                      " (in 'string', line 59, column 4 to column 16)",
                                                      " (in 'string', line 58, column 43 to line 60, column 3)",
                                                      " (in 'string', line 58, column 2 to line 63, column 3)",
                                                      " (in 'string', line 57, column 26 to line 65, column 1)",
                                                      " (in 'string', line 57, column 7 to line 87, column 1)",
                                                      " (in 'string', line 53, column 4 to line 54, column 77)",
                                                      " (in 'string', line 52, column 9 to line 55, column 3)",
                                                      " (in 'string', line 51, column 4 to column 16)",
                                                      " (in 'string', line 50, column 43 to line 52, column 3)",
                                                      " (in 'string', line 50, column 2 to line 55, column 3)",
                                                      " (in 'string', line 49, column 18 to line 57, column 1)",
                                                      " (in 'string', line 49, column 0 to line 87, column 1)",
                                                      " (in 'string', line 125, column 4 to line 126, column 82)",
                                                      " (in 'string', line 124, column 9 to line 127, column 3)",
                                                      " (in 'string', line 123, column 4 to column 18)",
                                                      " (in 'string', line 122, column 44 to line 124, column 3)",
                                                      " (in 'string', line 122, column 2 to line 127, column 3)",
                                                      " (in 'string', line 121, column 28 to line 128, column 1)",
                                                      " (in 'string', line 121, column 7 to line 128, column 1)",
                                                      " (in 'string', line 117, column 4 to line 118, column 86)",
                                                      " (in 'string', line 116, column 9 to line 119, column 3)",
                                                      " (in 'string', line 115, column 4 to column 18)",
                                                      " (in 'string', line 114, column 44 to line 116, column 3)",
                                                      " (in 'string', line 114, column 2 to line 119, column 3)",
                                                      " (in 'string', line 113, column 28 to line 121, column 1)",
                                                      " (in 'string', line 113, column 7 to line 128, column 1)",
                                                      " (in 'string', line 110, column 4 to column 47)",
                                                      " (in 'string', line 109, column 9 to line 111, column 3)",
                                                      " (in 'string', line 108, column 4 to column 18)",
                                                      " (in 'string', line 107, column 41 to line 109, column 3)",
                                                      " (in 'string', line 107, column 2 to line 111, column 3)",
                                                      " (in 'string', line 106, column 28 to line 113, column 1)",
                                                      " (in 'string', line 106, column 7 to line 128, column 1)",
                                                      " (in 'string', line 102, column 4 to line 103, column 100)",
                                                      " (in 'string', line 101, column 9 to line 104, column 3)",
                                                      " (in 'string', line 100, column 4 to column 18)",
                                                      " (in 'string', line 99, column 47 to line 101, column 3)",
                                                      " (in 'string', line 99, column 2 to line 104, column 3)",
                                                      " (in 'string', line 98, column 28 to line 106, column 1)",
                                                      " (in 'string', line 98, column 7 to line 128, column 1)",
                                                      " (in 'string', line 94, column 4 to line 95, column 83)",
                                                      " (in 'string', line 93, column 9 to line 96, column 3)",
                                                      " (in 'string', line 92, column 4 to column 18)",
                                                      " (in 'string', line 91, column 47 to line 93, column 3)",
                                                      " (in 'string', line 91, column 2 to line 96, column 3)",
                                                      " (in 'string', line 90, column 20 to line 98, column 1)",
                                                      " (in 'string', line 90, column 0 to line 128, column 1)",
                                                      " (in 'string', line 136, column 7 to column 13)",
                                                      " (in 'string', line 137, column 16 to column 17)",
                                                      " (in 'string', line 138, column 9 to column 10)",
                                                      " (in 'string', line 141, column 9 to column 10)"};
#include <stan_meta_header.hpp>
class model_random_jzs_dstudy final : public model_base_crtp<model_random_jzs_dstudy> {
private:
  int N;
  Eigen::Matrix<double, -1, 1> y;
  Eigen::Matrix<double, -1, 1> SE;
  int B;
  std::vector<int> P;
  std::vector<std::vector<int>> b_idx;
  Eigen::Matrix<double, -1, 1> rscale;
  Eigen::Matrix<double, -1, -1> X;
  std::vector<Eigen::Matrix<double, -1, -1>> L;
  int d_family;
  Eigen::Matrix<double, -1, 1> d_param;
  Eigen::Matrix<double, -1, 1> d_bnd;
  int tau_family;
  Eigen::Matrix<double, -1, 1> tau_param;
  Eigen::Matrix<double, -1, 1> tau_bnd;
  double d_const;
  double tau_const;
  Eigen::Matrix<double, -1, 1> SE2;
  int beta_1dim__;
 
public:
  ~model_random_jzs_dstudy() { }
  
  inline std::string model_name() const final { return "model_random_jzs_dstudy"; }
  inline std::vector<std::string> model_compile_info() const noexcept {
    return std::vector<std::string>{"stanc_version = stanc3 v2.26.1-4-gd72b68b7-dirty", "stancflags = "};
  }
  
  
  model_random_jzs_dstudy(stan::io::var_context& context__,
                          unsigned int random_seed__ = 0,
                          std::ostream* pstream__ = nullptr) : model_base_crtp(0) {
    using local_scalar_t__ = double ;
    boost::ecuyer1988 base_rng__ = 
        stan::services::util::create_rng(random_seed__, 0);
    (void) base_rng__;  // suppress unused var warning
    static const char* function__ = "model_random_jzs_dstudy_namespace::model_random_jzs_dstudy";
    (void) function__;  // suppress unused var warning
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      current_statement__ = 46;
      context__.validate_dims("data initialization","N","int",
          context__.to_vec());
      N = std::numeric_limits<int>::min();
      
      current_statement__ = 46;
      N = context__.vals_i("N")[(1 - 1)];
      current_statement__ = 46;
      current_statement__ = 46;
      check_greater_or_equal(function__, "N", N, 0);
      current_statement__ = 47;
      validate_non_negative_index("y", "N", N);
      current_statement__ = 48;
      context__.validate_dims("data initialization","y","double",
          context__.to_vec(N));
      y = Eigen::Matrix<double, -1, 1>(N);
      stan::math::fill(y, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> y_flat__;
        current_statement__ = 48;
        assign(y_flat__, nil_index_list(), context__.vals_r("y"),
          "assigning variable y_flat__");
        current_statement__ = 48;
        pos__ = 1;
        current_statement__ = 48;
        for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
          current_statement__ = 48;
          assign(y, cons_list(index_uni(sym1__), nil_index_list()),
            y_flat__[(pos__ - 1)], "assigning variable y");
          current_statement__ = 48;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 49;
      validate_non_negative_index("SE", "N", N);
      current_statement__ = 50;
      context__.validate_dims("data initialization","SE","double",
          context__.to_vec(N));
      SE = Eigen::Matrix<double, -1, 1>(N);
      stan::math::fill(SE, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> SE_flat__;
        current_statement__ = 50;
        assign(SE_flat__, nil_index_list(), context__.vals_r("SE"),
          "assigning variable SE_flat__");
        current_statement__ = 50;
        pos__ = 1;
        current_statement__ = 50;
        for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
          current_statement__ = 50;
          assign(SE, cons_list(index_uni(sym1__), nil_index_list()),
            SE_flat__[(pos__ - 1)], "assigning variable SE");
          current_statement__ = 50;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 50;
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        current_statement__ = 50;
        current_statement__ = 50;
        check_greater_or_equal(function__, "SE[sym1__]", SE[(sym1__ - 1)], 0);
      }
      current_statement__ = 51;
      context__.validate_dims("data initialization","B","int",
          context__.to_vec());
      B = std::numeric_limits<int>::min();
      
      current_statement__ = 51;
      B = context__.vals_i("B")[(1 - 1)];
      current_statement__ = 51;
      current_statement__ = 51;
      check_greater_or_equal(function__, "B", B, 1);
      current_statement__ = 52;
      validate_non_negative_index("P", "B", B);
      current_statement__ = 53;
      context__.validate_dims("data initialization","P","int",
          context__.to_vec(B));
      P = std::vector<int>(B, std::numeric_limits<int>::min());
      
      current_statement__ = 53;
      assign(P, nil_index_list(), context__.vals_i("P"),
        "assigning variable P");
      current_statement__ = 53;
      for (int sym1__ = 1; sym1__ <= B; ++sym1__) {
        current_statement__ = 53;
        current_statement__ = 53;
        check_greater_or_equal(function__, "P[sym1__]", P[(sym1__ - 1)], 1);}
      current_statement__ = 54;
      validate_non_negative_index("b_idx", "B", B);
      current_statement__ = 55;
      context__.validate_dims("data initialization","b_idx","int",
          context__.to_vec(B, 2));
      b_idx = std::vector<std::vector<int>>(B, std::vector<int>(2, std::numeric_limits<int>::min()));
      
      {
        std::vector<int> b_idx_flat__;
        current_statement__ = 55;
        assign(b_idx_flat__, nil_index_list(), context__.vals_i("b_idx"),
          "assigning variable b_idx_flat__");
        current_statement__ = 55;
        pos__ = 1;
        current_statement__ = 55;
        for (int sym1__ = 1; sym1__ <= 2; ++sym1__) {
          current_statement__ = 55;
          for (int sym2__ = 1; sym2__ <= B; ++sym2__) {
            current_statement__ = 55;
            assign(b_idx,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              b_idx_flat__[(pos__ - 1)], "assigning variable b_idx");
            current_statement__ = 55;
            pos__ = (pos__ + 1);}}
      }
      current_statement__ = 55;
      for (int sym1__ = 1; sym1__ <= B; ++sym1__) {
        current_statement__ = 55;
        for (int sym2__ = 1; sym2__ <= 2; ++sym2__) {
          current_statement__ = 55;
          current_statement__ = 55;
          check_greater_or_equal(function__, "b_idx[sym1__, sym2__]",
                                 b_idx[(sym1__ - 1)][(sym2__ - 1)], 1);}}
      current_statement__ = 55;
      for (int sym1__ = 1; sym1__ <= B; ++sym1__) {
        current_statement__ = 55;
        for (int sym2__ = 1; sym2__ <= 2; ++sym2__) {
          current_statement__ = 55;
          current_statement__ = 55;
          check_less_or_equal(function__, "b_idx[sym1__, sym2__]",
                              b_idx[(sym1__ - 1)][(sym2__ - 1)], sum(P));}}
      current_statement__ = 56;
      validate_non_negative_index("rscale", "B", B);
      current_statement__ = 57;
      context__.validate_dims("data initialization","rscale","double",
          context__.to_vec(B));
      rscale = Eigen::Matrix<double, -1, 1>(B);
      stan::math::fill(rscale, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> rscale_flat__;
        current_statement__ = 57;
        assign(rscale_flat__, nil_index_list(), context__.vals_r("rscale"),
          "assigning variable rscale_flat__");
        current_statement__ = 57;
        pos__ = 1;
        current_statement__ = 57;
        for (int sym1__ = 1; sym1__ <= B; ++sym1__) {
          current_statement__ = 57;
          assign(rscale, cons_list(index_uni(sym1__), nil_index_list()),
            rscale_flat__[(pos__ - 1)], "assigning variable rscale");
          current_statement__ = 57;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 57;
      for (int sym1__ = 1; sym1__ <= B; ++sym1__) {
        current_statement__ = 57;
        current_statement__ = 57;
        check_greater_or_equal(function__, "rscale[sym1__]",
                               rscale[(sym1__ - 1)], 0);}
      current_statement__ = 58;
      validate_non_negative_index("X", "N", N);
      current_statement__ = 59;
      validate_non_negative_index("X", "sum(P)", sum(P));
      current_statement__ = 60;
      context__.validate_dims("data initialization","X","double",
          context__.to_vec(N, sum(P)));
      X = Eigen::Matrix<double, -1, -1>(N, sum(P));
      stan::math::fill(X, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> X_flat__;
        current_statement__ = 60;
        assign(X_flat__, nil_index_list(), context__.vals_r("X"),
          "assigning variable X_flat__");
        current_statement__ = 60;
        pos__ = 1;
        current_statement__ = 60;
        for (int sym1__ = 1; sym1__ <= sum(P); ++sym1__) {
          current_statement__ = 60;
          for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
            current_statement__ = 60;
            assign(X,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              X_flat__[(pos__ - 1)], "assigning variable X");
            current_statement__ = 60;
            pos__ = (pos__ + 1);}}
      }
      current_statement__ = 61;
      validate_non_negative_index("L", "B", B);
      current_statement__ = 62;
      validate_non_negative_index("L", "max(P)", max(P));
      current_statement__ = 63;
      validate_non_negative_index("L", "max(P)", max(P));
      current_statement__ = 64;
      context__.validate_dims("data initialization","L","double",
          context__.to_vec(B, max(P), max(P)));
      L = std::vector<Eigen::Matrix<double, -1, -1>>(B, Eigen::Matrix<double, -1, -1>(
        max(P), max(P)));
      stan::math::fill(L, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> L_flat__;
        current_statement__ = 64;
        assign(L_flat__, nil_index_list(), context__.vals_r("L"),
          "assigning variable L_flat__");
        current_statement__ = 64;
        pos__ = 1;
        current_statement__ = 64;
        for (int sym1__ = 1; sym1__ <= max(P); ++sym1__) {
          current_statement__ = 64;
          for (int sym2__ = 1; sym2__ <= max(P); ++sym2__) {
            current_statement__ = 64;
            for (int sym3__ = 1; sym3__ <= B; ++sym3__) {
              current_statement__ = 64;
              assign(L,
                cons_list(index_uni(sym3__),
                  cons_list(index_uni(sym2__),
                    cons_list(index_uni(sym1__), nil_index_list()))),
                L_flat__[(pos__ - 1)], "assigning variable L");
              current_statement__ = 64;
              pos__ = (pos__ + 1);}}}
      }
      current_statement__ = 65;
      context__.validate_dims("data initialization","d_family","int",
          context__.to_vec());
      d_family = std::numeric_limits<int>::min();
      
      current_statement__ = 65;
      d_family = context__.vals_i("d_family")[(1 - 1)];
      current_statement__ = 65;
      current_statement__ = 65;
      check_greater_or_equal(function__, "d_family", d_family, 1);
      current_statement__ = 66;
      context__.validate_dims("data initialization","d_param","double",
          context__.to_vec(3));
      d_param = Eigen::Matrix<double, -1, 1>(3);
      stan::math::fill(d_param, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> d_param_flat__;
        current_statement__ = 66;
        assign(d_param_flat__, nil_index_list(), context__.vals_r("d_param"),
          "assigning variable d_param_flat__");
        current_statement__ = 66;
        pos__ = 1;
        current_statement__ = 66;
        for (int sym1__ = 1; sym1__ <= 3; ++sym1__) {
          current_statement__ = 66;
          assign(d_param, cons_list(index_uni(sym1__), nil_index_list()),
            d_param_flat__[(pos__ - 1)], "assigning variable d_param");
          current_statement__ = 66;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 67;
      context__.validate_dims("data initialization","d_bnd","double",
          context__.to_vec(2));
      d_bnd = Eigen::Matrix<double, -1, 1>(2);
      stan::math::fill(d_bnd, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> d_bnd_flat__;
        current_statement__ = 67;
        assign(d_bnd_flat__, nil_index_list(), context__.vals_r("d_bnd"),
          "assigning variable d_bnd_flat__");
        current_statement__ = 67;
        pos__ = 1;
        current_statement__ = 67;
        for (int sym1__ = 1; sym1__ <= 2; ++sym1__) {
          current_statement__ = 67;
          assign(d_bnd, cons_list(index_uni(sym1__), nil_index_list()),
            d_bnd_flat__[(pos__ - 1)], "assigning variable d_bnd");
          current_statement__ = 67;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 67;
      current_statement__ = 67;
      check_ordered(function__, "d_bnd", d_bnd);
      current_statement__ = 68;
      context__.validate_dims("data initialization","tau_family","int",
          context__.to_vec());
      tau_family = std::numeric_limits<int>::min();
      
      current_statement__ = 68;
      tau_family = context__.vals_i("tau_family")[(1 - 1)];
      current_statement__ = 68;
      current_statement__ = 68;
      check_greater_or_equal(function__, "tau_family", tau_family, 1);
      current_statement__ = 69;
      context__.validate_dims("data initialization","tau_param","double",
          context__.to_vec(3));
      tau_param = Eigen::Matrix<double, -1, 1>(3);
      stan::math::fill(tau_param, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> tau_param_flat__;
        current_statement__ = 69;
        assign(tau_param_flat__, nil_index_list(),
          context__.vals_r("tau_param"),
          "assigning variable tau_param_flat__");
        current_statement__ = 69;
        pos__ = 1;
        current_statement__ = 69;
        for (int sym1__ = 1; sym1__ <= 3; ++sym1__) {
          current_statement__ = 69;
          assign(tau_param, cons_list(index_uni(sym1__), nil_index_list()),
            tau_param_flat__[(pos__ - 1)], "assigning variable tau_param");
          current_statement__ = 69;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 70;
      context__.validate_dims("data initialization","tau_bnd","double",
          context__.to_vec(2));
      tau_bnd = Eigen::Matrix<double, -1, 1>(2);
      stan::math::fill(tau_bnd, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> tau_bnd_flat__;
        current_statement__ = 70;
        assign(tau_bnd_flat__, nil_index_list(), context__.vals_r("tau_bnd"),
          "assigning variable tau_bnd_flat__");
        current_statement__ = 70;
        pos__ = 1;
        current_statement__ = 70;
        for (int sym1__ = 1; sym1__ <= 2; ++sym1__) {
          current_statement__ = 70;
          assign(tau_bnd, cons_list(index_uni(sym1__), nil_index_list()),
            tau_bnd_flat__[(pos__ - 1)], "assigning variable tau_bnd");
          current_statement__ = 70;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 70;
      current_statement__ = 70;
      check_ordered(function__, "tau_bnd", tau_bnd);
      current_statement__ = 71;
      d_const = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 71;
      d_const = 0;
      current_statement__ = 72;
      tau_const = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 72;
      tau_const = 0;
      current_statement__ = 73;
      validate_non_negative_index("SE2", "N", N);
      current_statement__ = 74;
      SE2 = Eigen::Matrix<double, -1, 1>(N);
      stan::math::fill(SE2, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 78;
      if (logical_gt(N, 0)) {
        current_statement__ = 76;
        for (int i = 1; i <= N; ++i) {
          current_statement__ = 75;
          assign(SE2, cons_list(index_uni(i), nil_index_list()),
            pow(SE[(i - 1)], 2), "assigning variable SE2");}
      } 
      current_statement__ = 113;
      if (logical_eq(d_family, 1)) {
        current_statement__ = 111;
        if ((primitive_value(is_inf(d_bnd[(1 - 1)])) && primitive_value(
            is_inf(d_bnd[(2 - 1)])))) {
          current_statement__ = 109;
          d_const = 0;
        } else {
          current_statement__ = 107;
          d_const = -log_diff_exp(
                       normal_lcdf(d_bnd[(2 - 1)], d_param[(1 - 1)],
                         d_param[(2 - 1)]),
                       normal_lcdf(d_bnd[(1 - 1)], d_param[(1 - 1)],
                         d_param[(2 - 1)]));
        }
      } else {
        current_statement__ = 106;
        if (logical_eq(d_family, 2)) {
          current_statement__ = 104;
          if ((primitive_value(is_inf(d_bnd[(1 - 1)])) && primitive_value(
              is_inf(d_bnd[(2 - 1)])))) {
            current_statement__ = 102;
            d_const = 0;
          } else {
            current_statement__ = 100;
            d_const = -log_diff_exp(
                         student_t_lcdf(d_bnd[(2 - 1)], d_param[(3 - 1)],
                           d_param[(1 - 1)], d_param[(2 - 1)]),
                         student_t_lcdf(d_bnd[(1 - 1)], d_param[(3 - 1)],
                           d_param[(1 - 1)], d_param[(2 - 1)]));
          }
        } else {
          current_statement__ = 99;
          if (logical_eq(d_family, 3)) {
            current_statement__ = 97;
            if ((primitive_value(logical_eq(d_bnd[(1 - 1)], 0)) &&
                primitive_value(logical_eq(d_bnd[(2 - 1)], 1)))) {
              current_statement__ = 95;
              d_const = 0;
            } else {
              current_statement__ = 93;
              d_const = -stan::math::log((d_bnd[(2 - 1)] - d_bnd[(1 - 1)]));
            }
          } else {
            current_statement__ = 92;
            if (logical_eq(d_family, 4)) {
              current_statement__ = 90;
              if ((primitive_value(logical_eq(d_bnd[(1 - 1)], 0)) &&
                  primitive_value(is_inf(d_bnd[(2 - 1)])))) {
                current_statement__ = 88;
                d_const = 0;
              } else {
                current_statement__ = 86;
                d_const = -log_diff_exp(
                             inv_gamma_lcdf(d_bnd[(2 - 1)], d_param[(1 - 1)],
                               d_param[(2 - 1)]),
                             inv_gamma_lcdf(d_bnd[(1 - 1)], d_param[(1 - 1)],
                               d_param[(2 - 1)]));
              }
            } else {
              current_statement__ = 85;
              if (logical_eq(d_family, 5)) {
                current_statement__ = 83;
                if ((primitive_value(logical_eq(d_bnd[(1 - 1)], 0)) &&
                    primitive_value(is_inf(d_bnd[(2 - 1)])))) {
                  current_statement__ = 81;
                  d_const = 0;
                } else {
                  current_statement__ = 79;
                  d_const = -log_diff_exp(
                               gamma_lcdf(d_bnd[(2 - 1)], d_param[(1 - 1)],
                                 d_param[(2 - 1)]),
                               gamma_lcdf(d_bnd[(1 - 1)], d_param[(1 - 1)],
                                 d_param[(2 - 1)]));
                }
              } 
            }
          }
        }
      }
      current_statement__ = 148;
      if (logical_eq(tau_family, 1)) {
        current_statement__ = 146;
        if ((primitive_value(is_inf(tau_bnd[(1 - 1)])) && primitive_value(
            is_inf(tau_bnd[(2 - 1)])))) {
          current_statement__ = 144;
          tau_const = 0;
        } else {
          current_statement__ = 142;
          tau_const = -log_diff_exp(
                         normal_lcdf(tau_bnd[(2 - 1)], tau_param[(1 - 1)],
                           tau_param[(2 - 1)]),
                         normal_lcdf(tau_bnd[(1 - 1)], tau_param[(1 - 1)],
                           tau_param[(2 - 1)]));
        }
      } else {
        current_statement__ = 141;
        if (logical_eq(tau_family, 2)) {
          current_statement__ = 139;
          if ((primitive_value(is_inf(tau_bnd[(1 - 1)])) && primitive_value(
              is_inf(tau_bnd[(2 - 1)])))) {
            current_statement__ = 137;
            tau_const = 0;
          } else {
            current_statement__ = 135;
            tau_const = -log_diff_exp(
                           student_t_lcdf(tau_bnd[(2 - 1)],
                             tau_param[(3 - 1)], tau_param[(1 - 1)],
                             tau_param[(2 - 1)]),
                           student_t_lcdf(tau_bnd[(1 - 1)],
                             tau_param[(3 - 1)], tau_param[(1 - 1)],
                             tau_param[(2 - 1)]));
          }
        } else {
          current_statement__ = 134;
          if (logical_eq(tau_family, 3)) {
            current_statement__ = 132;
            if ((primitive_value(logical_eq(tau_bnd[(1 - 1)], 0)) &&
                primitive_value(logical_eq(tau_bnd[(2 - 1)], 1)))) {
              current_statement__ = 130;
              tau_const = 0;
            } else {
              current_statement__ = 128;
              tau_const = -stan::math::log(
                             (tau_bnd[(2 - 1)] - tau_bnd[(1 - 1)]));
            }
          } else {
            current_statement__ = 127;
            if (logical_eq(tau_family, 4)) {
              current_statement__ = 125;
              if ((primitive_value(logical_eq(tau_bnd[(1 - 1)], 0)) &&
                  primitive_value(is_inf(tau_bnd[(2 - 1)])))) {
                current_statement__ = 123;
                tau_const = 0;
              } else {
                current_statement__ = 121;
                tau_const = -log_diff_exp(
                               inv_gamma_lcdf(tau_bnd[(2 - 1)],
                                 tau_param[(1 - 1)], tau_param[(2 - 1)]),
                               inv_gamma_lcdf(tau_bnd[(1 - 1)],
                                 tau_param[(1 - 1)], tau_param[(2 - 1)]));
              }
            } else {
              current_statement__ = 120;
              if (logical_eq(tau_family, 5)) {
                current_statement__ = 118;
                if ((primitive_value(logical_eq(tau_bnd[(1 - 1)], 0)) &&
                    primitive_value(is_inf(tau_bnd[(2 - 1)])))) {
                  current_statement__ = 116;
                  tau_const = 0;
                } else {
                  current_statement__ = 114;
                  tau_const = -log_diff_exp(
                                 gamma_lcdf(tau_bnd[(2 - 1)],
                                   tau_param[(1 - 1)], tau_param[(2 - 1)]),
                                 gamma_lcdf(tau_bnd[(1 - 1)],
                                   tau_param[(1 - 1)], tau_param[(2 - 1)]));
                }
              } 
            }
          }
        }
      }
      current_statement__ = 149;
      beta_1dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 149;
      beta_1dim__ = sum(P);
      current_statement__ = 149;
      validate_non_negative_index("beta", "sum(P)", beta_1dim__);
      current_statement__ = 150;
      validate_non_negative_index("g", "B", B);
      current_statement__ = 151;
      validate_non_negative_index("delta", "N", N);
      current_statement__ = 152;
      validate_non_negative_index("dstudy", "N", N);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    num_params_r__ = 0U;
    
    try {
      num_params_r__ += 1;
      num_params_r__ += 1;
      num_params_r__ += beta_1dim__;
      num_params_r__ += B;
      num_params_r__ += N;
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
  }
  template <bool propto__, bool jacobian__, typename VecR, typename VecI, stan::require_vector_like_t<VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline stan::scalar_type_t<VecR> log_prob_impl(VecR& params_r__,
                                                 VecI& params_i__,
                                                 std::ostream* pstream__ = nullptr) const {
    using T__ = stan::scalar_type_t<VecR>;
    using local_scalar_t__ = T__;
    T__ lp__(0.0);
    stan::math::accumulator<T__> lp_accum__;
    static const char* function__ = "model_random_jzs_dstudy_namespace::log_prob";
(void) function__;  // suppress unused var warning
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      local_scalar_t__ d;
      d = DUMMY_VAR__;
      
      current_statement__ = 1;
      d = in__.scalar();
      current_statement__ = 1;
      if (jacobian__) {
        current_statement__ = 1;
        d = stan::math::lub_constrain(d, d_bnd[(1 - 1)], d_bnd[(2 - 1)], lp__);
      } else {
        current_statement__ = 1;
        d = stan::math::lub_constrain(d, d_bnd[(1 - 1)], d_bnd[(2 - 1)]);
      }
      local_scalar_t__ tau;
      tau = DUMMY_VAR__;
      
      current_statement__ = 2;
      tau = in__.scalar();
      current_statement__ = 2;
      if (jacobian__) {
        current_statement__ = 2;
        tau = stan::math::lub_constrain(tau, tau_bnd[(1 - 1)],
                tau_bnd[(2 - 1)], lp__);
      } else {
        current_statement__ = 2;
        tau = stan::math::lub_constrain(tau, tau_bnd[(1 - 1)],
                tau_bnd[(2 - 1)]);
      }
      Eigen::Matrix<local_scalar_t__, -1, 1> beta;
      beta = Eigen::Matrix<local_scalar_t__, -1, 1>(beta_1dim__);
      stan::math::fill(beta, DUMMY_VAR__);
      
      current_statement__ = 3;
      beta = in__.vector(beta_1dim__);
      Eigen::Matrix<local_scalar_t__, -1, 1> g;
      g = Eigen::Matrix<local_scalar_t__, -1, 1>(B);
      stan::math::fill(g, DUMMY_VAR__);
      
      current_statement__ = 4;
      g = in__.vector(B);
      current_statement__ = 4;
      for (int sym1__ = 1; sym1__ <= B; ++sym1__) {
        current_statement__ = 4;
        if (jacobian__) {
          current_statement__ = 4;
          assign(g, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(g[(sym1__ - 1)], 0, lp__),
            "assigning variable g");
        } else {
          current_statement__ = 4;
          assign(g, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(g[(sym1__ - 1)], 0),
            "assigning variable g");
        }}
      Eigen::Matrix<local_scalar_t__, -1, 1> delta;
      delta = Eigen::Matrix<local_scalar_t__, -1, 1>(N);
      stan::math::fill(delta, DUMMY_VAR__);
      
      current_statement__ = 5;
      delta = in__.vector(N);
      Eigen::Matrix<local_scalar_t__, -1, 1> dstudy;
      dstudy = Eigen::Matrix<local_scalar_t__, -1, 1>(N);
      stan::math::fill(dstudy, DUMMY_VAR__);
      
      current_statement__ = 7;
      assign(dstudy, nil_index_list(),
        add(add(d, multiply(X, beta)), multiply(tau, delta)),
        "assigning variable dstudy");
      {
        current_statement__ = 8;
        lp_accum__.add(d_const);
        current_statement__ = 23;
        if (logical_eq(d_family, 1)) {
          current_statement__ = 21;
          lp_accum__.add(
            normal_lpdf<false>(d, d_param[(1 - 1)], d_param[(2 - 1)]));
        } else {
          current_statement__ = 20;
          if (logical_eq(d_family, 2)) {
            current_statement__ = 18;
            lp_accum__.add(
              student_t_lpdf<false>(d, d_param[(3 - 1)], d_param[(1 - 1)],
                d_param[(2 - 1)]));
          } else {
            current_statement__ = 17;
            if (logical_eq(d_family, 3)) {
              current_statement__ = 15;
              lp_accum__.add(
                beta_lpdf<false>(
                  ((d - d_bnd[(1 - 1)]) / (d_bnd[(2 - 1)] - d_bnd[(1 - 1)])),
                  d_param[(1 - 1)], d_param[(2 - 1)]));
            } else {
              current_statement__ = 14;
              if (logical_eq(d_family, 4)) {
                current_statement__ = 12;
                lp_accum__.add(
                  inv_gamma_lpdf<false>(d, d_param[(1 - 1)],
                    d_param[(2 - 1)]));
              } else {
                current_statement__ = 11;
                if (logical_eq(d_family, 5)) {
                  current_statement__ = 9;
                  lp_accum__.add(
                    gamma_lpdf<false>(d, d_param[(1 - 1)], d_param[(2 - 1)]));
                } 
              }
            }
          }
        }
        current_statement__ = 24;
        lp_accum__.add(tau_const);
        current_statement__ = 39;
        if (logical_eq(tau_family, 1)) {
          current_statement__ = 37;
          lp_accum__.add(
            normal_lpdf<false>(tau, tau_param[(1 - 1)], tau_param[(2 - 1)]));
        } else {
          current_statement__ = 36;
          if (logical_eq(tau_family, 2)) {
            current_statement__ = 34;
            lp_accum__.add(
              student_t_lpdf<false>(tau, tau_param[(3 - 1)],
                tau_param[(1 - 1)], tau_param[(2 - 1)]));
          } else {
            current_statement__ = 33;
            if (logical_eq(tau_family, 3)) {
              current_statement__ = 31;
              lp_accum__.add(
                beta_lpdf<false>(
                  ((tau - tau_bnd[(1 - 1)]) /
                    (tau_bnd[(2 - 1)] - tau_bnd[(1 - 1)])),
                  tau_param[(1 - 1)], tau_param[(2 - 1)]));
            } else {
              current_statement__ = 30;
              if (logical_eq(tau_family, 4)) {
                current_statement__ = 28;
                lp_accum__.add(
                  inv_gamma_lpdf<false>(tau, tau_param[(1 - 1)],
                    tau_param[(2 - 1)]));
              } else {
                current_statement__ = 27;
                if (logical_eq(tau_family, 5)) {
                  current_statement__ = 25;
                  lp_accum__.add(
                    gamma_lpdf<false>(tau, tau_param[(1 - 1)],
                      tau_param[(2 - 1)]));
                } 
              }
            }
          }
        }
        current_statement__ = 43;
        for (int b = 1; b <= B; ++b) {
          current_statement__ = 40;
          lp_accum__.add(
            inv_gamma_lpdf<false>(g[(b - 1)], .5,
              (pow(rscale[(b - 1)], 2) / 2.)));
          current_statement__ = 41;
          lp_accum__.add(
            multi_normal_cholesky_lpdf<false>(
              rvalue(beta,
                cons_list(
                  index_min_max(b_idx[(b - 1)][(1 - 1)], b_idx[(b - 1)][
                  (2 - 1)]), nil_index_list()), "beta"),
              rep_vector(0, P[(b - 1)]),
              multiply(stan::math::sqrt(g[(b - 1)]),
                rvalue(L,
                  cons_list(index_uni(b),
                    cons_list(index_min_max(1, P[(b - 1)]),
                      cons_list(index_min_max(1, P[(b - 1)]),
                        nil_index_list()))), "L"))));}
        current_statement__ = 44;
        lp_accum__.add(normal_lpdf<false>(delta, 0, 1));
        current_statement__ = 45;
        lp_accum__.add(normal_lpdf<false>(y, dstudy, SE));
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    lp_accum__.add(lp__);
    return lp_accum__.sum();
    } // log_prob_impl() 
    
  template <typename RNG, typename VecR, typename VecI, typename VecVar, stan::require_vector_like_vt<std::is_floating_point, VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr, stan::require_std_vector_vt<std::is_floating_point, VecVar>* = nullptr>
  inline void write_array_impl(RNG& base_rng__, VecR& params_r__,
                               VecI& params_i__, VecVar& vars__,
                               const bool emit_transformed_parameters__ = true,
                               const bool emit_generated_quantities__ = true,
                               std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.resize(0);
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    static const char* function__ = "model_random_jzs_dstudy_namespace::write_array";
(void) function__;  // suppress unused var warning
    (void) function__;  // suppress unused var warning
    double lp__ = 0.0;
    (void) lp__;  // dummy to suppress unused var warning
    stan::math::accumulator<double> lp_accum__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      double d;
      d = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 1;
      d = in__.scalar();
      current_statement__ = 1;
      d = stan::math::lub_constrain(d, d_bnd[(1 - 1)], d_bnd[(2 - 1)]);
      double tau;
      tau = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 2;
      tau = in__.scalar();
      current_statement__ = 2;
      tau = stan::math::lub_constrain(tau, tau_bnd[(1 - 1)], tau_bnd[(2 - 1)]);
      Eigen::Matrix<double, -1, 1> beta;
      beta = Eigen::Matrix<double, -1, 1>(beta_1dim__);
      stan::math::fill(beta, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 3;
      beta = in__.vector(beta_1dim__);
      Eigen::Matrix<double, -1, 1> g;
      g = Eigen::Matrix<double, -1, 1>(B);
      stan::math::fill(g, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 4;
      g = in__.vector(B);
      current_statement__ = 4;
      for (int sym1__ = 1; sym1__ <= B; ++sym1__) {
        current_statement__ = 4;
        assign(g, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_constrain(g[(sym1__ - 1)], 0),
          "assigning variable g");}
      Eigen::Matrix<double, -1, 1> delta;
      delta = Eigen::Matrix<double, -1, 1>(N);
      stan::math::fill(delta, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 5;
      delta = in__.vector(N);
      Eigen::Matrix<double, -1, 1> dstudy;
      dstudy = Eigen::Matrix<double, -1, 1>(N);
      stan::math::fill(dstudy, std::numeric_limits<double>::quiet_NaN());
      
      vars__.emplace_back(d);
      vars__.emplace_back(tau);
      for (int sym1__ = 1; sym1__ <= beta_1dim__; ++sym1__) {
        vars__.emplace_back(beta[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= B; ++sym1__) {
        vars__.emplace_back(g[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        vars__.emplace_back(delta[(sym1__ - 1)]);}
      if (logical_negation((primitive_value(emit_transformed_parameters__) ||
            primitive_value(emit_generated_quantities__)))) {
        return ;
      } 
      current_statement__ = 7;
      assign(dstudy, nil_index_list(),
        add(add(d, multiply(X, beta)), multiply(tau, delta)),
        "assigning variable dstudy");
      if (emit_transformed_parameters__) {
        for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
          vars__.emplace_back(dstudy[(sym1__ - 1)]);}
      } 
      if (logical_negation(emit_generated_quantities__)) {
        return ;
      } 
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // write_array_impl() 
    
  template <typename VecVar, typename VecI, stan::require_std_vector_t<VecVar>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline void transform_inits_impl(const stan::io::var_context& context__,
                                   VecI& params_i__, VecVar& vars__,
                                   std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.clear();
    vars__.reserve(num_params_r__);
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      double d;
      d = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 1;
      d = context__.vals_r("d")[(1 - 1)];
      double d_free__;
      d_free__ = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 1;
      d_free__ = stan::math::lub_free(d, d_bnd[(1 - 1)], d_bnd[(2 - 1)]);
      double tau;
      tau = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 2;
      tau = context__.vals_r("tau")[(1 - 1)];
      double tau_free__;
      tau_free__ = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 2;
      tau_free__ = stan::math::lub_free(tau, tau_bnd[(1 - 1)],
                     tau_bnd[(2 - 1)]);
      Eigen::Matrix<double, -1, 1> beta;
      beta = Eigen::Matrix<double, -1, 1>(beta_1dim__);
      stan::math::fill(beta, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> beta_flat__;
        current_statement__ = 3;
        assign(beta_flat__, nil_index_list(), context__.vals_r("beta"),
          "assigning variable beta_flat__");
        current_statement__ = 3;
        pos__ = 1;
        current_statement__ = 3;
        for (int sym1__ = 1; sym1__ <= beta_1dim__; ++sym1__) {
          current_statement__ = 3;
          assign(beta, cons_list(index_uni(sym1__), nil_index_list()),
            beta_flat__[(pos__ - 1)], "assigning variable beta");
          current_statement__ = 3;
          pos__ = (pos__ + 1);}
      }
      Eigen::Matrix<double, -1, 1> g;
      g = Eigen::Matrix<double, -1, 1>(B);
      stan::math::fill(g, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> g_flat__;
        current_statement__ = 4;
        assign(g_flat__, nil_index_list(), context__.vals_r("g"),
          "assigning variable g_flat__");
        current_statement__ = 4;
        pos__ = 1;
        current_statement__ = 4;
        for (int sym1__ = 1; sym1__ <= B; ++sym1__) {
          current_statement__ = 4;
          assign(g, cons_list(index_uni(sym1__), nil_index_list()),
            g_flat__[(pos__ - 1)], "assigning variable g");
          current_statement__ = 4;
          pos__ = (pos__ + 1);}
      }
      Eigen::Matrix<double, -1, 1> g_free__;
      g_free__ = Eigen::Matrix<double, -1, 1>(B);
      stan::math::fill(g_free__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 4;
      for (int sym1__ = 1; sym1__ <= B; ++sym1__) {
        current_statement__ = 4;
        assign(g_free__, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_free(g[(sym1__ - 1)], 0),
          "assigning variable g_free__");}
      Eigen::Matrix<double, -1, 1> delta;
      delta = Eigen::Matrix<double, -1, 1>(N);
      stan::math::fill(delta, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> delta_flat__;
        current_statement__ = 5;
        assign(delta_flat__, nil_index_list(), context__.vals_r("delta"),
          "assigning variable delta_flat__");
        current_statement__ = 5;
        pos__ = 1;
        current_statement__ = 5;
        for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
          current_statement__ = 5;
          assign(delta, cons_list(index_uni(sym1__), nil_index_list()),
            delta_flat__[(pos__ - 1)], "assigning variable delta");
          current_statement__ = 5;
          pos__ = (pos__ + 1);}
      }
      vars__.emplace_back(d_free__);
      vars__.emplace_back(tau_free__);
      for (int sym1__ = 1; sym1__ <= beta_1dim__; ++sym1__) {
        vars__.emplace_back(beta[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= B; ++sym1__) {
        vars__.emplace_back(g_free__[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        vars__.emplace_back(delta[(sym1__ - 1)]);}
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // transform_inits_impl() 
    
  inline void get_param_names(std::vector<std::string>& names__) const {
    
    names__.clear();
    names__.emplace_back("d");
    names__.emplace_back("tau");
    names__.emplace_back("beta");
    names__.emplace_back("g");
    names__.emplace_back("delta");
    names__.emplace_back("dstudy");
    } // get_param_names() 
    
  inline void get_dims(std::vector<std::vector<size_t>>& dimss__) const {
    dimss__.clear();
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(beta_1dim__)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(B)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(N)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(N)});
    
    } // get_dims() 
    
  inline void constrained_param_names(
                                      std::vector<std::string>& param_names__,
                                      bool emit_transformed_parameters__ = true,
                                      bool emit_generated_quantities__ = true) const
    final {
    
    param_names__.emplace_back(std::string() + "d");
    param_names__.emplace_back(std::string() + "tau");
    for (int sym1__ = 1; sym1__ <= beta_1dim__; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "beta" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= B; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "g" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "delta" + '.' + std::to_string(sym1__));
      }}
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "dstudy" + '.' + std::to_string(sym1__));
        }}
    }
    
    if (emit_generated_quantities__) {
      
    }
    
    } // constrained_param_names() 
    
  inline void unconstrained_param_names(
                                        std::vector<std::string>& param_names__,
                                        bool emit_transformed_parameters__ = true,
                                        bool emit_generated_quantities__ = true) const
    final {
    
    param_names__.emplace_back(std::string() + "d");
    param_names__.emplace_back(std::string() + "tau");
    for (int sym1__ = 1; sym1__ <= beta_1dim__; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "beta" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= B; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "g" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "delta" + '.' + std::to_string(sym1__));
      }}
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "dstudy" + '.' + std::to_string(sym1__));
        }}
    }
    
    if (emit_generated_quantities__) {
      
    }
    
    } // unconstrained_param_names() 
    
  inline std::string get_constrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"d\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"tau\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"beta\",\"type\":{\"name\":\"vector\",\"length\":" << beta_1dim__ << "},\"block\":\"parameters\"},{\"name\":\"g\",\"type\":{\"name\":\"vector\",\"length\":" << B << "},\"block\":\"parameters\"},{\"name\":\"delta\",\"type\":{\"name\":\"vector\",\"length\":" << N << "},\"block\":\"parameters\"},{\"name\":\"dstudy\",\"type\":{\"name\":\"vector\",\"length\":" << N << "},\"block\":\"transformed_parameters\"}]";
    return s__.str();
    } // get_constrained_sizedtypes() 
    
  inline std::string get_unconstrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"d\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"tau\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"beta\",\"type\":{\"name\":\"vector\",\"length\":" << beta_1dim__ << "},\"block\":\"parameters\"},{\"name\":\"g\",\"type\":{\"name\":\"vector\",\"length\":" << B << "},\"block\":\"parameters\"},{\"name\":\"delta\",\"type\":{\"name\":\"vector\",\"length\":" << N << "},\"block\":\"parameters\"},{\"name\":\"dstudy\",\"type\":{\"name\":\"vector\",\"length\":" << N << "},\"block\":\"transformed_parameters\"}]";
    return s__.str();
    } // get_unconstrained_sizedtypes() 
    
  
    // Begin method overload boilerplate
    template <typename RNG>
    inline void write_array(RNG& base_rng,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                            const bool emit_transformed_parameters = true,
                            const bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      std::vector<double> vars_vec(vars.size());
      std::vector<int> params_i;
      write_array_impl(base_rng, params_r, params_i, vars_vec,
          emit_transformed_parameters, emit_generated_quantities, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i) {
        vars.coeffRef(i) = vars_vec[i];
      }
    }
    template <typename RNG>
    inline void write_array(RNG& base_rng, std::vector<double>& params_r,
                            std::vector<int>& params_i,
                            std::vector<double>& vars,
                            bool emit_transformed_parameters = true,
                            bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      write_array_impl(base_rng, params_r, params_i, vars, emit_transformed_parameters, emit_generated_quantities, pstream);
    }
    template <bool propto__, bool jacobian__, typename T_>
    inline T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
                       std::ostream* pstream = nullptr) const {
      Eigen::Matrix<int, -1, 1> params_i;
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
    template <bool propto__, bool jacobian__, typename T__>
    inline T__ log_prob(std::vector<T__>& params_r,
                        std::vector<int>& params_i,
                        std::ostream* pstream = nullptr) const {
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
  
    inline void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream = nullptr) const final {
      std::vector<double> params_r_vec(params_r.size());
      std::vector<int> params_i;
      transform_inits_impl(context, params_i, params_r_vec, pstream);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i) {
        params_r.coeffRef(i) = params_r_vec[i];
      }
    }
    inline void transform_inits(const stan::io::var_context& context,
                                std::vector<int>& params_i,
                                std::vector<double>& vars,
                                std::ostream* pstream = nullptr) const final {
      transform_inits_impl(context, params_i, vars, pstream);
    }        
};
}
using stan_model = model_random_jzs_dstudy_namespace::model_random_jzs_dstudy;
#ifndef USING_R
// Boilerplate
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
stan::math::profile_map& get_stan_profile_data() {
  return model_random_jzs_dstudy_namespace::profiles__;
}
#endif
#endif
