% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_mvg_params.R
\name{generate_mvg_params}
\alias{generate_mvg_params}
\title{Generate multivariate Gaussian distribution parameters}
\usage{
generate_mvg_params(splitted_data = NULL, cor_matrix = NULL)
}
\arguments{
\item{splitted_data}{Splitted experimental data.}

\item{cor_matrix}{Correlation matrix}
}
\value{
Returns the parameters of the multivariate Gaussian distributions as well as a list of concatenated HEM readings
}
\description{
\code{generate_mvg_params} takes as input the experimental data along its correlation matrix to estimate the Sigma matrix and the vector of means to compute the multivariate Gaussian distribution
}
\examples{
n_pmcs <- 6
data_much <- mergingTools::process_raw_experiments(data = data_much_raw_vignette,
                                                   n_pmcs = n_pmcs)
cor_matrix <- mergingTools::correlation_matrix(splitted_data = data_much)
dep_lvl <- 0.85
# Remove the HEMs which are linearly dependant on other HEMs
cor_matrix_independent <- mergingTools::get_independent_matrix(cor_matrix = cor_matrix,
                                                               dep_lvl = dep_lvl)
mvg_params <- mergingTools::generate_mvg_params(splitted_data = data_much,
                                                cor_matrix = cor_matrix_independent)
}
\keyword{MUCH}
