% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gha.R
\name{use_gha}
\alias{use_gha}
\alias{use_gha_jwt_token}
\alias{use_gha_encrypted_token}
\title{GitHub Actions workflow helpers}
\usage{
use_gha_jwt_token(
  client_name = get_client_name(),
  jwt = "MEETUPR_JWT_TOKEN",
  client_key = "MEETUPR_client_key",
  overwrite = FALSE,
  filename = ".github/workflows/meetupr-jwt-token.yml"
)

use_gha_encrypted_token(
  token_path = get_encrypted_path(),
  overwrite = FALSE,
  filename = ".github/workflows/meetupr-rotate-token.yml"
)
}
\arguments{
\item{client_name}{A string representing the name of the client. By
default, it is set to \code{"meetupr"} and retrieved from the
\code{MEETUPR_CLIENT_NAME} environment variable.}

\item{jwt}{Name of the GitHub secret that contains the JWT token.
Defaults to "MEETUPR_JWT_TOKEN".}

\item{client_key}{Name of the GitHub secret that contains the client
id. Defaults to "MEETUPR_client_key".}

\item{overwrite}{If FALSE and file exists, function aborts.}

\item{filename}{Path to write the workflow YAML file.
Defaults to appropriate path in \verb{.github/workflows/}.}

\item{token_path}{Path to the encrypted token file in the repo.
Defaults to get_encrypted_path().}
}
\value{
Invisibly returns the path to the created workflow file.
}
\description{
Create GitHub Actions workflows for JWT and encrypted-token CI auth.
}
\details{
These helpers write workflow YAML into \verb{.github/workflows/} so you can
enable non-interactive authentication for meetupr in GitHub Actions.

Which helper to use:
\itemize{
\item use_gha_jwt_token(): For Meetup Pro accounts that use a static JWT
token. The generated workflow provides a JWT and client id as
repository secrets so the runner can authenticate via JWT.
\item use_gha_encrypted_token(): For regular OAuth apps. This creates a
rotation workflow that loads an encrypted \code{.meetupr.rds} token,
refreshes it when needed, and writes the rotated encrypted file
back to the repo. Requires a decryption password stored as a
repository secret (default: MEETUPR_ENCRYPT_PWD).
}

Important notes:
\itemize{
\item These functions only write the workflow YAML. They do not create
repository secrets or commit/push files for you.
\item Review the generated YAML and add the required secrets in your
repository settings before enabling the workflow.
}
}
\section{Functions}{
\itemize{
\item \code{use_gha_jwt_token()}: Create workflow for JWT token auth.

\item \code{use_gha_encrypted_token()}: Create workflow for encrypted token rotation.

}}
