% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fire_regime_instance.R
\name{fire_regime_instance}
\alias{fire_regime_instance}
\title{Fire regime instance}
\usage{
fire_regime_instance(sf, fire_regime)
}
\arguments{
\item{sf}{An object of class \code{\link[sf]{sf}} with the following columns:
\itemize{
\item{\code{geometry}: Spatial geometry.}
\item{\code{id}: Stand identifiers.}
\item{\code{represented_area_ha}: Area represented by each stand (in hectares).}
\item{\code{ignition_weights}: Relative weights to determine stands to be burned (optional).}
}}

\item{fire_regime}{A list of parameters defining the fire regime (see \code{\link{create_fire_regime}}).}
}
\value{
An integer matrix specifying the day of the year of burning of each landscape unit for every year in the fire regime definition.
Values are interpreted as follows:
\itemize{
\item{NA - No wildfire this year}
\item{0 - Wildfire will occur the driest day (i.e. the one with largest vapor pressure deficit).}
\item{1...366 - Day of the year when wildfire will occur}
}
}
\description{
Applies a fire regime object over a set of landscape units to determine a fire realization
}
\details{
The function randomly determines the landscape units that will burn every year, depending on the specifications
of the fire regime object. Users can define their own fire regime instances from other models (e.g. a fire landscape model)
and then use those directly in functions \code{\link{fordyn_spatial}} or \code{\link{fordyn_scenario}}.
}
\examples{
# Load example data
data("example_ifn")

# Assume that each stand represents 1km2 = 100 ha
example_ifn$represented_area_ha <- 100

# Define fire regime characteristics
reg1 <- create_fire_regime(c("2002" = 200, "2003" = 500)) 

# Create a fire regime instance
m1 <- fire_regime_instance(example_ifn, reg1)

# Check number of plots burned
colSums(!is.na(m1))

# Define fire regime characteristics with stochastic area burned
reg2 <- create_fire_regime(annual_burned_area = c("2002" = 200, "2003" = 500),
                           sd_burned_area = c("2002" = 0.4, "2003" = 0.5)) 

# Create a fire regime instance
m2 <- fire_regime_instance(example_ifn, reg2)

# Check number of plots burned
colSums(!is.na(m2))

}
\seealso{
\code{\link{create_fire_regime}}, \code{\link{fordyn_spatial}}, \code{\link{fordyn_scenario}}
}
\author{
Miquel De \enc{Cáceres}{Caceres} Ainsa, CREAF
}
