% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_estimates.R
\name{plot_estimates}
\alias{plot_estimates}
\title{Wrapper function to plot the JAGS estimates}
\usage{
plot_estimates(jagsdata, model_output)
}
\arguments{
\item{jagsdata}{Output of the mcmsupply::get_modelinputs() function.}

\item{model_output}{The output of the mcmsupply::run_jags_model() function.}
}
\value{
A list of ggplot objects.
}
\description{
Wrapper function to plot the JAGS estimates
}
\examples{
\dontrun{
raw_data <- get_data(national=TRUE, local=TRUE, mycountry="Nepal")
jagsdata <- get_modelinputs(startyear=1990, endyear=2030.5, nsegments=12, raw_data)
mod <- run_jags_model(jagsdata, n_iter=5, n_burnin=1, n_thin=1)
plots <- plot_estimates(jagsdata = jagsdata, model_output = mod)
}
}
