% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/totals.R
\name{agg_totals}
\alias{agg_totals}
\title{Aggregate Across Groups}
\usage{
agg_totals(
  mcmodule,
  mc_name,
  agg_keys = NULL,
  agg_suffix = NULL,
  prefix = NULL,
  name = NULL,
  summary = TRUE,
  keep_variates = FALSE,
  agg_func = NULL
)
}
\arguments{
\item{mcmodule}{mcmodule object containing nodes and data}

\item{mc_name}{name of node to aggregate}

\item{agg_keys}{grouping variables for aggregation}

\item{agg_suffix}{Suffix for aggregated node name (default: "agg")}

\item{prefix}{Optional prefix for output node name - includes metadata as add_prefix() (default: NULL)}

\item{name}{Custom name for output node (optional)}

\item{summary}{whether to include summary statistics (default: TRUE)}

\item{keep_variates}{whether to preserve individual values (default: FALSE)}

\item{agg_func}{aggregation method ("prob", "sum", "avg", or NULL)}
}
\value{
mcmodule with new aggregated node added
}
\description{
Combines node values across specified grouping variables using different aggregation methods.
The aggregation method can be specified via agg_func parameter:
\itemize{
\item "prob": Combined probability assuming independence
\item "sum": Sum of values
\item "avg": Average of values
\item NULL: defaults to "sum" if mc_name ends in "_n", else defaults to "prob"
}
}
\examples{
imports_mcmodule <- agg_totals(
  imports_mcmodule, "no_detect_a",
  agg_keys = c("scenario_id", "pathogen")
)
print(imports_mcmodule$node_list$no_detect_a_agg$summary)
}
