% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mc_network.R
\name{visNetwork_nodes}
\alias{visNetwork_nodes}
\title{Generate Network Node Table for Visualization}
\usage{
visNetwork_nodes(
  mcmodule,
  variate = 1,
  color_pal = NULL,
  color_by = NULL,
  inputs = FALSE
)
}
\arguments{
\item{mcmodule}{An mcmodule object containing the network structure}

\item{variate}{Integer specifying which variate to extract (default: 1)}

\item{color_pal}{Custom color palette for nodes (optional)}

\item{color_by}{Column name to determine node colors (optional)}

\item{inputs}{Include non-node inputs: data-sets, data-frames and columns (optional)}
}
\value{
A data frame formatted for visNetwork with columns:
\itemize{
\item id: Unique node identifier
\item color: Node color based on type/category
\item grouping: Module association
\item expression: Node expression or type
\item title: Hover text containing node details
}
}
\description{
Creates a formatted node table for visualization with visNetwork.
Includes styling and formatting for network visualization.
}
