% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_inla_model.R
\name{fit_inla_model}
\alias{fit_inla_model}
\title{Fit INLA model}
\usage{
fit_inla_model(
  formula,
  data_stack,
  spde,
  samplesize_vec = 1,
  precision_vec = 1,
  family = "binomial",
  link = "logit",
  fixed_effects_pc_prior = list(threshold = 3, prob_above = 0.05),
  verbose = TRUE
)
}
\arguments{
\item{formula}{(character) INLA formula to fit. Generated in
\code{\link[=prepare_inla_data_stack]{prepare_inla_data_stack()}}, then interpreted using \code{\link[stats:formula]{stats::as.formula()}} within the
call to \code{\link[INLA:inla]{INLA::inla()}}.}

\item{data_stack}{Stacked data, covariates, and spatial index. Generated in
\code{\link[=prepare_inla_data_stack]{prepare_inla_data_stack()}}.}

\item{spde}{SPDE object generated by \code{\link[=prepare_inla_data_stack]{prepare_inla_data_stack()}}.}

\item{samplesize_vec}{(\code{integer(N)}, default 1) Sample sizes for each data observation.
Only used for binomial data models.}

\item{precision_vec}{(\code{numeric(N)}, default 1) Precision for each data observation.
Only used for gaussian data models.}

\item{family}{(character, default 'binomial') GLM family to use. For more information,
see \code{\link[stats:family]{stats::family()}}.}

\item{link}{(character, default 'logit') Link function to use, typically related to the
GLM \code{family}.}

\item{fixed_effects_pc_prior}{A named list specifying the penalized complexity prior
for all fixed effects except for the intercept. The two named items are "threshold",
the test threshold for the size of each fixed effect, and "prob_above", the prior
probability that the beta for each covariate will EXCEED that threshold.}

\item{verbose}{(\code{logical(1)}, default TRUE) Log progress for INLA model fitting?}
}
\value{
A fitted INLA model object created by \code{\link[INLA:inla]{INLA::inla()}}
}
\description{
Fit an INLA model based on a constructed data stack and formula
}
\details{
Using \code{\link[INLA:inla]{INLA::inla()}} with reasonable defaults and settings tuned to predict
across a grid.
}
\seealso{
\link{MbgModelRunner}
}
\concept{model_fit}
