% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transformations.R
\name{transform_unitfrechet}
\alias{transform_unitfrechet}
\title{Transform the columns of a dataset to (approximately) unit Frechet margins}
\usage{
transform_unitfrechet(data)
}
\arguments{
\item{data, }{array or vector with the data which columns are to be transformed}
}
\value{
array or vector of same shape and type as data with the transformed data with unit
Frechet margins-
}
\description{
Transforms columns of dataset to unit Frechet margins, to ensure
the theoretical requirements are satisfied for the application of
\code{\link{max_stable_prcomp}} using the empirical distribution function.
}
\examples{
# sample some data
dat <- rnorm(1000)
transformed_dat <- transform_unitfrechet(dat)

# Look at a plot of distribution
boxplot(transformed_dat)
plot(stats::ecdf(transformed_dat))
}
\seealso{
\code{\link[=max_stable_prcomp]{max_stable_prcomp()}}, \code{\link[=transform_orig_margins]{transform_orig_margins()}}, [mev::fit.gev())] for information about why to transform data.

[mev::fit.gev())]: R:mev::fit.gev())
}
