% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Compute.Model.R
\name{Compute.Model}
\alias{Compute.Model}
\title{Evaluation of decision tree nodes}
\usage{
Compute.Model(tree, utilities, weights)
}
\arguments{
\item{tree}{initial tree structure with utilities in its leafs.}

\item{utilities}{data.table with ordered columns containing the values of utilities.}

\item{weights}{weights for the decision model.}
}
\value{
data.table structure containing the utilities of the model for every level the decision
tree.
}
\description{
Evaluation of decision tree nodes. All the MAUT model is computed at every level 
the utilities are computed considering the given weights.
}
\details{
The whole decision model can be computed a any level and represented in a table format.
}
\examples{
vignette( topic = 'Running_MAUT', package = 'mau' )
}
\seealso{
\code{\link{Stand.String}}, \code{\link{Read.Utilities}}, \code{\link{Eval.Utilities}},
\code{\link{Read.Tree}}, \code{\link{Make.Decision.Tree}}, \code{\link{Sim.Const.Weights}}.
}
\author{
Pedro Guarderas, Andrés Lopez
\email{pedro.felipe.guarderas@gmail.com}
}
