% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expand.R
\name{expand_to_tidy}
\alias{expand_to_tidy}
\title{Expand a \code{matsindf} data frame}
\usage{
expand_to_tidy(
  .DF,
  matnames = "matnames",
  matvals = "matvals",
  rownames = "rownames",
  colnames = "colnames",
  rowtypes = "rowtypes",
  coltypes = "coltypes",
  drop = NA
)
}
\arguments{
\item{.DF}{The data frame containing \pkg{matsindf}-style matrices.
(\code{.DF} may also be a named list of matrices, in which case
names of the matrices are taken from the names of items in the list and
list items are expected to be matrices.)}

\item{matnames}{The name of the column in \code{.DF} containing matrix names (a string).
Default is "matnames".}

\item{matvals}{The name of the column in \code{.DF} containing IO-style matrices
or constants (a string).
This will also be the name of the column containing matrix entries
in the output data frame.
Default is "matvals".}

\item{rownames}{The name for the output column of row names (a string).
Default is "rownames".}

\item{colnames}{The name for the output column of column names (a string).
Default is "colnames".}

\item{rowtypes}{An optional name for the output column of row types (a string).
Default is "rowtypes".}

\item{coltypes}{The optional name for the output column of column types (a string).
Default is "coltypes".}

\item{drop}{If specified, the value to be dropped from output,
For example, \code{drop = 0} will cause \code{0} entries in the matrices
to be deleted from output.
If \code{NA}, no values are dropped from output.
Default is \code{NA}.}
}
\value{
A tidy data frame containing expanded \pkg{matsindf}-style matrices.
}
\description{
Any tidy data frame of matrices (in which each row represents one matrix observation)
can also be represented as a tidy data frame
with each non-zero matrix entry as an observation on its own row.
This function and \code{collapse_to_matrices()} convert between the two representations.
}
\details{
Names for output columns are specified in the \code{rownames}, \code{colnames},
\code{rowtypes}, and \code{coltypes}, arguments.
The entries of the \pkg{matsindf}-style matrices are stored in an output column named \code{values.}
}
\examples{
library(dplyr)
library(matsbyname)
ptype <- "Products"
itype <- "Industries"
tidy <- data.frame(Country  = c( "GH",  "GH",  "GH",  "GH",  "GH",  "GH",  "GH",
                                 "US",  "US",  "US",  "US", "GH", "US"),
                  Year      = c( 1971,  1971,  1971,  1971,  1971,  1971,  1971,
                                 1980,  1980,  1980,  1980, 1971, 1980),
                  matrix    = c(  "U",   "U",   "Y",   "Y",   "Y",   "V",   "V",
                                  "U",   "U",   "Y",   "Y", "eta", "eta"),
                  row       = c(  "c1",  "c2",  "c1",  "c2",  "c2",  "i1",  "i2",
                                  "c1",  "c1",  "c1",  "c2", NA, NA),
                  col       = c(  "i1",  "i2",  "i1",  "i2",  "i3",  "c1",  "c2",
                                  "i1",  "i2",  "i1",  "i2", NA, NA),
                  rowtypes  = c( ptype, ptype, ptype, ptype, ptype, itype, itype,
                                 ptype, ptype, ptype, ptype, NA, NA),
                  coltypes  = c( itype, itype, itype, itype, itype, ptype, ptype,
                                 itype, itype, itype, itype, NA, NA),
                  vals      = c(11  ,  22,    11 ,   22 ,   23 ,   11 ,   22 ,
                                11 ,   12 ,   11 ,   22,   0.2, 0.3)) \%>\%
  group_by(Country, Year, matrix)
mats <- collapse_to_matrices(tidy, matnames = "matrix", rownames = "row", colnames = "col",
                             rowtypes = "rowtypes", coltypes = "coltypes",
                             matvals = "vals") \%>\%
  ungroup()
expand_to_tidy(mats, matnames = "matrix", matvals = "vals",
                     rownames = "rows", colnames = "cols",
                     rowtypes = "rt",   coltypes = "ct")
expand_to_tidy(mats, matnames = "matrix", matvals = "vals",
                     rownames = "rows", colnames = "cols",
                     rowtypes = "rt",   coltypes = "ct", drop = 0)
}
