% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delete.R
\name{delete_record}
\alias{delete_record}
\title{Delete Records from a Data Frame}
\usage{
delete_record(.data, position = NULL, ...)
}
\arguments{
\item{.data}{A data frame from which records will be deleted.}

\item{position}{A numeric vector specifying the row positions to be deleted. If `NULL`, behavior is determined
by the number of rows in the data frame and additional arguments passed to the `truncate` function.}

\item{...}{Additional arguments passed to the `truncate` function. Specifically, the `keep_rows` argument
can be used to decide whether non-NA cells in the data frame are cleared when truncating.}
}
\value{
A modified data frame with the specified rows removed. If `position` is `NULL`, the function either
  returns the original data frame or an empty data frame, based on the `keep_rows` argument in the `truncate` function.
}
\description{
Deletes specific rows from a data frame or clears the entire data frame by leveraging the `truncate` function.
If no position is provided, it will issue a message and either return the unchanged data or use `truncate`
to empty the data frame, depending on additional arguments.
}
\details{
- If `position` is `NULL` and the data frame has more than one row, a message is issued, and no records are deleted.
- If `position` is a numeric vector, the specified rows are deleted using `dplyr::slice()`.
- If `position` is empty or invalid (e.g., not numeric), the function stops with an appropriate error message.
- When no rows remain after deletion, the function calls `truncate` to handle the data frame, with behavior
  controlled by the `keep_rows` argument passed through `...`.
}
\examples{
df <- data.frame(A = 1:5, B = letters[1:5])

# Delete a specific row
delete_record(df, position = 2)

# Delete multiple rows
delete_record(df, position = c(2, 4))

# Use truncate to clear the data frame
delete_record(df, position = NULL, keep_rows = FALSE)

# Keep non-NA cells but empty rows
delete_record(df, position = NULL, keep_rows = TRUE)

}
