% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/G_dh.R
\name{G_dh}
\alias{G_dh}
\title{Diffuse irradiance on Mars horizontal surface}
\usage{
G_dh(
  Ls,
  phi,
  longitude,
  Ts = NULL,
  z = Z(Ls = Ls, phi = phi, Ts = Ts),
  tau,
  al = albedo(latitude = phi, longitude = longitude, tau = tau)
)
}
\arguments{
\item{Ls}{Areocentric longitude [deg]}

\item{phi}{Planetary latitude [deg]}

\item{longitude}{Planetary longitude [deg]}

\item{Ts}{Solar time [h]. Can be NULL for daily calculations}

\item{z}{Sun zenith angle [deg]. If not provided, calculated from Ls, phi, and Ts}

\item{tau}{Atmospheric optical depth (dimensionless)}

\item{al}{Surface albedo (dimensionless, 0-1). If not provided, calculated from latitude, longitude, and tau}
}
\value{
Diffuse irradiance on horizontal surface [W/m²]
}
\description{
Calculates the diffuse solar irradiance (scattered by atmospheric dust) incident on a
horizontal surface on Mars. Computed as the difference between global and direct beam
irradiance. Implements Equation 16 from Appelbaum & Flood (1990).
}
