% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/testmc.R
\name{testmc}
\alias{testmc}
\title{Global envelope tests for random labelling.}
\usage{
testmc(X,
fun,
nsim = 100,
fun_args = list(),     
get_args = list(),     
rlabel_args = list()
)
}
\arguments{
\item{X}{An object of class ppp or lpp.}

\item{fun}{Function that computes the desired mark correlation function.}

\item{nsim}{Number of permutations.}

\item{fun_args}{Arguments passed to the chosen mark correlation function.}

\item{get_args}{Arguments passed to the \code{\link[GET]{global_envelope_test}}.}

\item{rlabel_args}{Arguments passed to the \code{\link[spatstat.random]{rlabel}}.}
}
\value{
Either an object of class global_envelope or a list of such objects if the point pattern has multiple marks or the employed mark correlation function is of type LIMA.
}
\description{
Generic function to perform global envelope test for random labelling using mark correlation functions.
}
\details{
Generic function to perform global envelope test for random labelling using mark correlation functions. 

If the point pattern has several real-valued marks, then the random labelling test will be performed for each mark individually, and the output will be a list of global envelop tests one per each mark.

If the mark correlation function is any of the LIMA family, a random labelling test will be performed for each individual point.
}
\examples{
\donttest{
 library(spatstat.geom)
 library(spatstat.random)
 library(spatstat.explore)
 library(spatstat.linnet)

#######################################
## 1. Planar point patterns (ppp)
#######################################

# ---------------------------------------------------------
# GLOBAL MARK CORRELATION (real-valued marks)
# ---------------------------------------------------------
X <- rpoispp(200)
marks(X) <- data.frame(m1 = runif(npoints(X), 1, 10))

ts1 <- testmc(X,
              fun = mcorr.ppp,
              fun_args = list(ftype = "stoyan", method = "density"))
plot(ts1)
# Global mark correlation (real-valued marks)

ts2 <- testmc(X,
              fun = mcorrinhom.ppp,
              fun_args = list(ftype = "stoyan",
                               method = "density",
                               method_lambda = "kernel"))
plot(ts2)
# Inhomogeneous global mark correlation (real-valued marks)


# ---------------------------------------------------------
# GLOBAL FUNCTIONAL MARK CORRELATION (function-valued marks)
# ---------------------------------------------------------
marks(X) <- data.frame(
  t1 = runif(npoints(X), 1, 10),
  t2 = runif(npoints(X), 1, 10),
  t3 = runif(npoints(X), 1, 10),
  t4 = runif(npoints(X), 1, 10),
  t5 = runif(npoints(X), 1, 10)
)

ts3 <- testmc(X,
              fun = fmcorr,
              fun_args = list(ftype = "stoyan", method = "density"))
plot(ts3)
# Global functional mark correlation (function-valued marks)

ts4 <- testmc(X,
              fun = fmcorrinhom,
              fun_args = list(ftype = "stoyan",
                               method = "density",
                               method_lambda = "kernel",
                               bw = bw.scott))
plot(ts4)
# Inhomogeneous functional mark correlation (function-valued marks)


# ---------------------------------------------------------
# LOCAL MARK CORRELATION (real-valued marks)
# ---------------------------------------------------------
X <- rpoispp(200)
marks(X) <- data.frame(m1 = runif(npoints(X), 1, 10))

ts5 <- testmc(X,
              fun = lmcorr.ppp,
              fun_args = list(ftype = "stoyan", method = "density"))
plot(ts5[[1]])
# Local mark correlation (real-valued marks)

ts6 <- testmc(X,
              fun = lmcorrinhom.ppp,
              fun_args = list(ftype = "stoyan",
                               method = "density",
                               method_lambda = "kernel"))
plot(ts6[[1]])
# Inhomogeneous local mark correlation (real-valued marks)


# ---------------------------------------------------------
# LOCAL FUNCTIONAL MARK CORRELATION (function-valued marks)
# ---------------------------------------------------------
marks(X) <- data.frame(
  t1 = runif(npoints(X), 1, 10),
  t2 = runif(npoints(X), 1, 10),
  t3 = runif(npoints(X), 1, 10),
  t4 = runif(npoints(X), 1, 10),
  t5 = runif(npoints(X), 1, 10)
)

ts7 <- testmc(X,
              fun = lfmcorr,
              fun_args = list(ftype = "stoyan", method = "density"))
plot(ts7[[1]])
# Local functional mark correlation (function-valued marks)

ts8 <- testmc(X,
              fun = lfmcorrinhom,
              fun_args = list(ftype = "stoyan",
                               method = "density",
                               method_lambda = "kernel",
                               bw = bw.scott))
plot(ts8[[1]])
# Inhomogeneous local functional mark correlation (function-valued marks)


#######################################
## 2. Linear network point patterns (lpp)
#######################################

Xl <- rpoislpp(40, simplenet)

# ---------------------------------------------------------
# GLOBAL MARK CORRELATION (real-valued marks)
# ---------------------------------------------------------
marks(Xl) <- data.frame(m1 = runif(npoints(Xl), 1, 10))

ts9 <- testmc(Xl,
              fun = mcorr.lpp,
              fun_args = list(ftype = "stoyan", method = "density"))
plot(ts9)
# Global mark correlation on linear networks (real-valued marks)

ts10 <- testmc(Xl,
               fun = mcorrinhom.lpp,
               fun_args = list(ftype = "stoyan",
                                method = "density",
                                method_lambda = "kernel"))
plot(ts10)
# Inhomogeneous global mark correlation on linear networks (real-valued marks)


# ---------------------------------------------------------
# GLOBAL FUNCTIONAL MARK CORRELATION (function-valued marks)
# ---------------------------------------------------------
marks(Xl) <- data.frame(
  t1 = runif(npoints(Xl), 1, 10),
  t2 = runif(npoints(Xl), 1, 10),
  t3 = runif(npoints(Xl), 1, 10),
  t4 = runif(npoints(Xl), 1, 10),
  t5 = runif(npoints(Xl), 1, 10)
)

ts11 <- testmc(Xl,
               fun = fmcorr,
               fun_args = list(ftype = "stoyan", method = "density"))
plot(ts11)
# Global functional mark correlation on linear networks (function-valued marks)

ts12 <- testmc(Xl,
               fun = fmcorrinhom,
               fun_args = list(ftype = "stoyan",
                                method = "density",
                                method_lambda = "kernel",
                                bw = bw.scott.iso))
plot(ts12)
# Inhomogeneous global functional mark correlation on linear networks
# (function-valued marks)


# ---------------------------------------------------------
# LOCAL MARK CORRELATION (real-valued marks)
# ---------------------------------------------------------
marks(Xl) <- data.frame(m1 = runif(npoints(Xl), 1, 10))

ts13 <- testmc(Xl,
               fun = lmcorr.lpp,
               fun_args = list(ftype = "stoyan", method = "density"))
plot(ts13[[1]])
# Local mark correlation on linear networks (real-valued marks)

ts14 <- testmc(Xl,
               fun = lmcorrinhom.lpp,
               fun_args = list(ftype = "stoyan",
                                method = "density",
                                method_lambda = "kernel"))
plot(ts14[[1]])
# Inhomogeneous local mark correlation on linear networks (real-valued marks)


# ---------------------------------------------------------
# LOCAL FUNCTIONAL MARK CORRELATION (function-valued marks)
# ---------------------------------------------------------
marks(Xl) <- data.frame(
  t1 = runif(npoints(Xl), 1, 10),
  t2 = runif(npoints(Xl), 1, 10),
  t3 = runif(npoints(Xl), 1, 10),
  t4 = runif(npoints(Xl), 1, 10),
  t5 = runif(npoints(Xl), 1, 10)
)

ts15 <- testmc(Xl,
               fun = lfmcorr,
               fun_args = list(ftype = "stoyan", method = "density"))
plot(ts15[[1]])
# Local functional mark correlation on linear networks (function-valued marks)

ts16 <- testmc(Xl,
               fun = lfmcorrinhom,
               fun_args = list(ftype = "stoyan",
                                method = "density",
                                method_lambda = "kernel",
                                bw = bw.scott.iso))
plot(ts16[[1]])
# Inhomogeneous local functional mark correlation on linear networks
# (function-valued marks)

}

}
\references{
Eckardt, M., & Moradi, M. (2024). Marked spatial point processes: current state and extensions to point processes on linear networks. Journal of Agricultural, Biological and Environmental Statistics, 29(2), 346-378.

Moradi, M., & Eckardt, M. (2025). Inhomogeneous mark correlation functions for general marked point processes.

Eckardt, M., & Moradi, M. (2025). Local indicators of mark association for marked spatial point processes.
}
\seealso{
\code{\link[GET]{global_envelope_test}}, \code{\link[markstat]{mcorr.ppp}}, \code{\link[markstat]{mcorr.lpp}}, \code{\link[markstat]{mcorrinhom.ppp}}, \code{\link[markstat]{mcorrinhom.lpp}},  \code{\link[markstat]{fmcorr}}, \code{\link[markstat]{lmcorr.ppp}}, \code{\link[markstat]{lmcorr.lpp}}.
}
\author{
Mehdi Moradi \email{m2.moradi@yahoo.com}
}
