% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cxi_calc.R
\name{cxi_calc}
\alias{cxi_calc}
\title{Tidy Calculation of Customer Experience Index}
\usage{
cxi_calc(survey_data, ..., cx_high = 4, cx_low = 2)
}
\arguments{
\item{survey_data}{Raw survey data. Needs to be one row per survey with the three CXi question
responses having column names of needs, ease and emotion}

\item{...}{optional columns by which to group the CXi calculation. There is no limit to
the number of grouping variables chosen. Too many will likely result in CXi calculations
that are too fragmented / based on very small survey counts.}

\item{cx_high}{Threshold in scale where response at or above is a "high"}

\item{cx_low}{Threshold in scale where response at or below is a "low"}
}
\value{
Data frame with CXi and survey count for each combination of the grouping variables
}
\description{
Simplifies the calculation of Customer Experience Index (CXi) from raw survey data within
the tidyverse framework.
}
\details{
Customer Experience Index is a metric created by Forrester to help companies systematically
measure customer experience in a way that their research has found is connected to
improving customer loyalty. More information can be found at https://go.forrester.com/analytics/cx-index/

The calculation across an entire sample of surveys is simple. A customer experience
manager may want to calculate CXi across many different dimensions and filtering
in different ways; the functions in this package utilize the tidy framework to streamline
calculating CXi along as many dimensions as desired.
}
\examples{
needs <- sample(5, 100, replace = TRUE)
ease <- sample(5, 100, replace = TRUE)
emotion <- sample(5, 100, replace = TRUE)
cx_date <- rep(seq.Date(from = as.Date("2019-01-01"), to = as.Date("2019-01-10"), by = "day"), 10)
cx_group <- rep(c("a", "b", "c", "d"), 25)
df <- data.frame(needs, ease, emotion, cx_date, cx_group)
cxi_calc(df, cx_group)
}
