% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_precipitation_chelsa.R
\name{precipitation_chelsa}
\alias{precipitation_chelsa}
\alias{calc_precipitation_chelsa}
\title{Calculate precipitation average based on CHELSA}
\usage{
calc_precipitation_chelsa(years = 1979:2018, engine = "extract")
}
\arguments{
\item{years}{A numeric vector indicating the years for which to calculate
precipitation statistics.}

\item{engine}{The preferred processing functions from either one of "zonal",
"extract" or "exactextract" as character.}
}
\value{
A function that returns an indicator tibble with variable
precipitation and sum of precipitation (in mm/m^2) as value.
}
\description{
This functions allows to calculate averaged precipitation
from the CHELSA downscaled precipitation layers. Based on
user-selected years, monthly averages of precipitation are calculated.
}
\details{
The required resources for this indicator are:
\itemize{
\item \link{chelsa}
}
}
\examples{
\dontshow{
mapme.biodiversity:::.copy_resource_dir(file.path(tempdir(), "mapme-data"))
}
\dontrun{
library(sf)
library(mapme.biodiversity)

outdir <- file.path(tempdir(), "mapme-data")
dir.create(outdir, showWarnings = FALSE)

mapme_options(
  outdir = outdir,
  verbose = FALSE
)

aoi <- system.file("extdata", "sierra_de_neiba_478140_2.gpkg",
  package = "mapme.biodiversity"
) \%>\%
  read_sf() \%>\%
  get_resources(get_chelsa(years = 2010)) \%>\%
  calc_indicators(
    calc_precipitation_chelsa(
      years = 2010,
      engine = "extract"
    )
  ) \%>\%
  portfolio_long()

aoi
}
}
\keyword{indicator}
