% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/turf.R
\name{turf_centroid}
\alias{turf_centroid}
\title{Calculate centroid of geometries}
\usage{
turf_centroid(
  map,
  layer_id = NULL,
  data = NULL,
  coordinates = NULL,
  source_id,
  input_id = NULL
)
}
\arguments{
\item{map}{A mapboxgl, maplibre, mapboxgl_proxy, or maplibre_proxy object.}

\item{layer_id}{The ID of a layer or source containing geometries (mutually exclusive with data and coordinates).}

\item{data}{An sf object containing geometries (mutually exclusive with layer_id and coordinates).}

\item{coordinates}{A list of coordinate pairs list(c(lng,lat), c(lng,lat), ...) for multiple points (mutually exclusive with layer_id and data).}

\item{source_id}{The ID for the new source containing the centroid. Required.}

\item{input_id}{Optional. Character string specifying the Shiny input ID suffix for storing results. If NULL (default), no input is registered. For proxy operations, the result will be available as \code{input[[paste0(map_id, "_turf_", input_id)]]}.}
}
\value{
The map or proxy object for method chaining.
}
\description{
This function calculates the centroid of geometries in a layer or sf object.
The result is added as a source to the map, which can then be styled using add_circle_layer(), etc.
}
