% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maplibre.R
\name{maplibre}
\alias{maplibre}
\title{Initialize a Maplibre GL Map}
\usage{
maplibre(
  style = carto_style("voyager"),
  center = c(0, 0),
  zoom = 0,
  bearing = 0,
  pitch = 0,
  projection = "globe",
  bounds = NULL,
  width = "100\%",
  height = NULL,
  ...
)
}
\arguments{
\item{style}{The style JSON to use.}

\item{center}{A numeric vector of length 2 specifying the initial center of the map.}

\item{zoom}{The initial zoom level of the map.}

\item{bearing}{The initial bearing (rotation) of the map, in degrees.}

\item{pitch}{The initial pitch (tilt) of the map, in degrees.}

\item{projection}{The map projection to use (e.g., "mercator", "globe").}

\item{bounds}{The bounding box to fit the map to. Accepts one of the following:
\itemize{
\item \code{sf} object;
\item output of \code{st_bbox()};
\item unnamed numeric vector of the form \code{c(xmin, ymin, xmax, ymax)}.
}}

\item{width}{The width of the output htmlwidget.}

\item{height}{The height of the output htmlwidget.}

\item{...}{Additional named parameters to be passed to the MapLibre GL JS Map.
See the MapLibre GL JS documentation for a full list of options:
\url{https://maplibre.org/maplibre-gl-js/docs/API/type-aliases/MapOptions/}.
Common options include:
\itemize{
\item \code{minZoom} / \code{maxZoom}: Minimum and maximum zoom levels (0-24).
\item \code{maxBounds}: Restrict panning to a bounding box, specified as
\code{list(c(sw_lng, sw_lat), c(ne_lng, ne_lat))}.
\item \code{dragRotate}: If \code{FALSE}, disables rotation via mouse drag (default \code{TRUE}).
\item \code{touchZoomRotate}: If \code{FALSE}, disables pinch-to-rotate on touch (default \code{TRUE}).
\item \code{scrollZoom}: If \code{FALSE}, disables scroll wheel zoom (default \code{TRUE}).
}}
}
\value{
An HTML widget for a MapLibre GL map.
}
\description{
Initialize a Maplibre GL Map
}
\examples{
\dontrun{
# Basic map
maplibre()

# Constrained map with zoom limits and disabled rotation
maplibre(
  bounds = my_sf_object,
  minZoom = 5,
  maxZoom = 12,
  dragRotate = FALSE,
  touchZoomRotate = FALSE
)
}
}
