% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers.R
\name{add_popups}
\alias{add_popups}
\title{Add popups to a layer}
\usage{
add_popups(map, layer_id, popup)
}
\arguments{
\item{map}{A \link{mapboxer} object.}

\item{layer_id}{The ID of the layer to which you want to add the popups.}

\item{popup}{A \href{https://github.com/janl/mustache.js}{mustache} template
in which the tags refer to the properties of the layer's data object.}
}
\description{
Usually you will add the popups in the \link{add_layer} function by setting the \code{popup}
  parameter.
}
\examples{
LAYER_ID <- "crashes"

mustache_tpl <- "
  <b>Date:</b> {{date}}</br>
  <b>Time:</b> {{time}}</br>
  <b>Number of persons injured:</b> {{injured}}
"

map <- motor_vehicle_collisions_nyc \%>\%
  as_mapbox_source() \%>\%
  mapboxer(
    center = c(-73.9165, 40.7114),
    zoom = 9
  ) \%>\%
  add_circle_layer(
    circle_color = "red",
    circle_blur = 1,
    filter = list(">", "injured", 0),
    id = LAYER_ID
  ) \%>\%
  add_popups(
    LAYER_ID,
    popup = mustache_tpl
  )

if (interactive()) map
}
