% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delineate_with_similarity.R
\name{delineate_with_similarity}
\alias{delineate_with_similarity}
\title{Delineate clusters from a similarity matrix}
\usage{
delineate_with_similarity(sim_matrix, threshold, method = "complete")
}
\arguments{
\item{sim_matrix}{A \eqn{n \times n} similarity matrix, with \eqn{n} the number of spectra. Columns should be named as the rows.}

\item{threshold}{A numeric value indicating the minimal similarity between two spectra. Adjust accordingly to the similarity metric used.}

\item{method}{The method of hierarchical clustering to use. The default and recommended method is "complete", but any methods from \link[stats:hclust]{stats::hclust} are valid.}
}
\value{
A tibble of \eqn{n} rows for each spectra and 3 columns:
\itemize{
\item \code{name}: the rownames of the similarity matrix indicating the spectra names
\item \code{membership}: integers stating the cluster number to which the spectra belong to. It starts from 1 to \eqn{c}, the total number of clusters.
\item \code{cluster_size}: integers indicating the total number of spectra in the corresponding cluster.
}
}
\description{
From a matrix of spectra similarity (e.g., with the cosine metric,
or Pearson product moment), infer the species clusters based on a
threshold \strong{above} (or \strong{equal to}) which spectra are considered alike.
}
\details{
The similarity matrix is converted to a distance matrix by subtracting the value one. This approach works for cosine similarity and positive correlations that have an upper bound of 1. Clusters are then delineated using hierarchical clustering. The default method of hierarchical clustering is the complete linkage (also known as farthest neighbor clustering) to ensure that the within-group minimum similarity of each cluster respects the threshold. See the Details section of \link[stats:hclust]{stats::hclust} for others valid methods to use.
}
\examples{
# Toy similarity matrix between the six example spectra of
#  three species. The cosine metric is used and a value of
#  zero indicates dissimilar spectra and a value of one
#  indicates identical spectra.
cosine_similarity <- matrix(
  c(
    1, 0.79, 0.77, 0.99, 0.98, 0.98,
    0.79, 1, 0.98, 0.79, 0.8, 0.8,
    0.77, 0.98, 1, 0.77, 0.77, 0.77,
    0.99, 0.79, 0.77, 1, 1, 0.99,
    0.98, 0.8, 0.77, 1, 1, 1,
    0.98, 0.8, 0.77, 0.99, 1, 1
  ),
  nrow = 6,
  dimnames = list(
    c(
      "species1_G2", "species2_E11", "species2_E12",
      "species3_F7", "species3_F8", "species3_F9"
    ),
    c(
      "species1_G2", "species2_E11", "species2_E12",
      "species3_F7", "species3_F8", "species3_F9"
    )
  )
)
# Delineate clusters based on a 0.92 threshold applied
#  to the similarity matrix
delineate_with_similarity(cosine_similarity, threshold = 0.92)
}
\seealso{
For similarity metrics: \href{https://rdrr.io/cran/coop/man/cosine.html}{\code{coop::tcosine}}, \href{https://rdrr.io/r/stats/cor.html}{\code{stats::cor}}, \href{https://rdrr.io/cran/Hmisc/man/rcorr.html}{\code{Hmisc::rcorr}}. For using taxonomic identifications for clusters : \link{delineate_with_identification}. For further analyses: \link{set_reference_spectra}.
}
