% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{adsl_sat}
\alias{adsl_sat}
\title{Patient data from single arm study}
\format{
a data frame with 500 rows and 8 columns:
\describe{
\item{USUBJID}{Unique subject identifiers for patients.}
\item{ARM}{Assigned treatment arm.}
\item{AGE}{Age in years at baseline.}
\item{SEX}{Sex of patient recorded as character \code{"Male"}/\code{"Female"}.}
\item{SMOKE}{Smoking status at baseline as integer \code{1}/\code{0}.}
\item{ECOG0}{Indicator of ECOG score = 0 at baseline as integer \code{1}/\code{0}.}
\item{N_PR_THER}{Number of prior therapies received as integer \verb{1, 2, 3, 4}.}
\item{SEX_MALE}{Indicator of \code{SEX == "Male"} as numeric \code{1}/\code{0}.}

}
}
\usage{
adsl_sat
}
\description{
Patient data from single arm study
}
\seealso{
Other unanchored datasets: 
\code{\link{adrs_sat}},
\code{\link{adtte_sat}},
\code{\link{agd}},
\code{\link{centered_ipd_sat}},
\code{\link{pseudo_ipd_sat}},
\code{\link{weighted_sat}}
}
\concept{unanchored datasets}
\keyword{dataset}
