% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/07-data_summarize.R
\name{dossier_summarize}
\alias{dossier_summarize}
\title{Generate an assessment report and summary of a dossier}
\usage{
dossier_summarize(
  dossier,
  group_by = NULL,
  taxonomy = NULL,
  valueType_guess = TRUE
)
}
\arguments{
\item{dossier}{List of data frame(s), each of them being datasets.}

\item{group_by}{A character string identifying the column in the dataset
to use as a grouping variable. Elements will be grouped by this
column.}

\item{taxonomy}{An optional data frame identifying a variable classification
schema.}

\item{valueType_guess}{Whether the output should include a more accurate
valueType that could be applied to the dataset. TRUE by default.}
}
\value{
A list of data frames containing overall assessment reports and summaries grouped by dataset.
}
\description{
Assesses and summarizes the content and structure of a dossier
(list of datasets) and generates reports of the results. This function can
be used to evaluate data structure, presence of specific fields, coherence
across elements, and data dictionary formats, and to summarize additional
information about variable distributions and descriptive statistics.
}
\details{
A dossier is a named list containing at least one data frame or more,
each of them being datasets. The name of each data frame will be use as the
reference name of the dataset.

A taxonomy is a classification schema that can be defined for variable
attributes. A taxonomy is usually extracted from an
\href{https://www.obiba.org/pages/products/opal/}{Opal environment}, and a
taxonomy object is a data frame that must contain at least the columns
\code{taxonomy}, \code{vocabulary}, and \code{terms}. Additional details about Opal
taxonomies are
\href{https://opaldoc.obiba.org/en/latest/web-user-guide/administration/taxonomies.html}{available online}.

The valueType is a declared property of a variable that is required in
certain functions to determine handling of the variables. Specifically,
valueType refers to the
\href{https://opaldoc.obiba.org/en/dev/variables-data.html#value-types}{OBiBa data type of a variable}.
The valueType is specified in a data dictionary in a column 'valueType' and
can be associated with variables as attributes. Acceptable valueTypes
include 'text', 'integer', 'decimal', 'boolean', datetime', 'date'. The full
list of OBiBa valueType possibilities and their correspondence with R data
types are available using \link{valueType_list}. The valueType can be used to
coerce the variable to the corresponding data type.
}
\examples{
\donttest{

# use madshapR_examples provided by the package
library(dplyr)

###### Example : a dataset list is a dossier by definition.
    
dataset1 <- as_dataset(madshapR_examples$`dataset_example` \%>\% group_by(pick('gndr')))
dataset2 <- as_dataset(madshapR_examples$`dataset_example - error`, col_id = "part_id")
dossier <- dossier_create(list(dataset1,dataset2))

summary_dossier <- dossier_summarize(dossier)
glimpse(summary_dossier)

}

}
