% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mStats.R
\name{egen}
\alias{egen}
\title{Categorize a numerical variable}
\usage{
egen(data, var, cut = NULL, lbl = NULL, new_var = NULL)
}
\arguments{
\item{data}{data.frame}

\item{var}{existing variable}

\item{cut}{either a number or a numeric vector}

\item{lbl}{labels to specify}

\item{new_var}{name of new variable to be created}
}
\value{
data.frame
}
\description{
\code{egen()} transforms a numeric vector to a factor vector.
}
\details{
\code{egen} allows easy conversion of a numerical variable to a categorical
variable.

If only a number is specified in \code{cut}, it categorizes
into equal intervals based on that number. If no value is set
for \code{cut}, the default interval is \code{10}.

\strong{Automatic naming new variable}

If \code{new_var} is not specified, new names will be automatically
created by appending \verb{_cat} as suffix.
\code{VARNAME`_cat`}

\strong{Automatic Labelling}

If \code{lbl} is not specified, labels are constructed in
\code{`##-##`}.
}
\examples{

x <- egen(infert, age)
tab(x, age_cat)

\dontrun{
## Set cut-off points
x <- egen(infert, age, c(26, 31, 36, 41))
tab(x, age_cat)

## Add labels and give a new name
x <- egen(infert, age, c(26, 31, 36, 41),
         lbl = c("<= 25", "26 - 30", "31 - 35",
           "36 - 40", "41+"),
         new_var = age_grp)
tab(x, age_grp)
}

}
\author{
Email: \email{dr.myominnoo@gmail.com}

Website: \url{https://myominnoo.github.io/}
}
