% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mStats.R
\name{ilog}
\alias{ilog}
\alias{ilog.close}
\alias{ilog.clear}
\title{Create a copy of your output in a text format}
\usage{
ilog(logfile = "log.txt", append = FALSE)

ilog.close()

ilog.clear()
}
\arguments{
\item{logfile}{Name of desired log file in \code{.txt} format}

\item{append}{logical value}
}
\description{
\code{ilog()} creates a text copy of your output.
\code{ilog.close()} closes the \code{ilog()} function.
\code{ilog.clear()} clears for the prompt error caused
when the environment is removed.
}
\details{
\code{ilog} is a two-step function that allows you a record of your console.
A log is a file containing what you type and console output. If a name is not
specified, then \code{ilog} will use the name \code{<unnamed>.txt}.

\code{ilog} opens a log file and \code{ilog.close} close the file.

\strong{Warnings}:

However, clearing objects from the workspace along with hidden objects
removes \code{ilog}'s \code{.logenv} environment, hence throwing an error
when it's attempted to be closed. An error message
\code{Error in (function (cmd, res, s, vis)  : object '.logenv' not found}
will be thrown.

In that case, console prompt is stuck at \code{log> }. If
this error occurs, use \code{ilog.clear()} function to revert back to
normal.
}
\examples{

\dontrun{
## my first log
ilog("../myFirstLog.tx")
str(infert)
str(iris)
ilog.close()

## in case of error: ".logenv" not found
# ilog.clear()
}
}
\author{
Email: \email{dr.myominnoo@gmail.com}

Website: \url{https://myominnoo.github.io/}
}
