% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fcts_used_for_ind_comp.R
\name{mst.computation}
\alias{mst.computation}
\title{Compute the Minimum Spanning Tree (MST) linking species of a given
assemblage}
\usage{
mst.computation(sp_faxes_coord_k)
}
\arguments{
\item{sp_faxes_coord_k}{a matrix relating species coordinates for species
present in a given assemblage.}
}
\value{
A dist object summarizing the MST for all species of a given
assemblage \code{mst_asb_k}.
}
\description{
This function computes the MST linking species of a given assemblage and is
used to compute FEve index.
}
\examples{
# Load Species*Traits dataframe:
 data("fruits_traits", package = "mFD")

# Load Assemblages*Species dataframe:      
 data("baskets_fruits_weights", package = "mFD") 

# Load Traits categories dataframe:
 data("fruits_traits_cat", package = "mFD") 
 
# Compute functional distance 
 sp_dist_fruits <- mFD::funct.dist(sp_tr         = fruits_traits,
                                   tr_cat        = fruits_traits_cat,
                                   metric        = "gower",
                                   scale_euclid  = "scale_center",
                                   ordinal_var   = "classic",
                                   weight_type   = "equal",
                                   stop_if_NA    = TRUE)
  
# Compute functional spaces quality to retrieve species coordinates matrix:
 fspaces_quality_fruits <- mFD::quality.fspaces(
                                  sp_dist             = sp_dist_fruits, 
                                  maxdim_pcoa         = 10,
                                  deviation_weighting = "absolute",
                                  fdist_scaling       = FALSE,
                                  fdendro             = "average")
 
# Retrieve species coordinates matrix:
 sp_faxes_coord_fruits <- fspaces_quality_fruits$details_fspaces$sp_pc_coord

# Compute the distance of "pear" to its nearest neighbor(s):
 mst_fruits <- mst.computation(sp_faxes_coord_fruits)
 mst_fruits
}
\author{
Camille Magneville and Sebastien Villeger
}
