% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lunar.package.R
\name{lunar.phase}
\alias{lunar.phase}
\title{Lunar Phase}
\usage{
lunar.phase(x, shift = 0, ..., name = FALSE)
}
\arguments{
\item{x}{A vector of \code{\link[base]{Date}} values.}

\item{shift}{The number of hours by which to shift the calculation of lunar phase.
By default lunar phase is calculated at 12 noon UT.}

\item{...}{Other optional arguments are ignored.}

\item{name}{Optional parameter indicating whether the return is a factor variable
By default lunar phase is returned in radians.
If assigned the value 8, it returns a factor variable with
8 phase levels.
If \code{TRUE} or any value other than 0 or 8,
it returns a factor variable with 4 phase labels.}
}
\description{
Returns the lunar phase on specified dates.
}
\details{
Adapted from function 
  \code{moon.illumination} in from the
  R4MFCL project (not an R package), which was developed
  by the Secretariat of the Pacific Community (SPC).
  The R4MFCL project was led by Simon Hoyle, and also includes code
  by Shelton Harley, Nick Davies, and Adam Langley of the SPC,
  and Pierre Kleiber of the US National Marine Fisheries Service.
  Pierre Kleiber is the author of the
  \code{moon.illumination} function.

  Code from project R4MFCL is distributed under the MIT License:

    \url{https://opensource.org/licenses/mit-license.php}

  Here is a link to the R4MFCL project:

    \url{https://code.google.com/archive/p/r4mfcl/}

  The R4MFCL code was modified as follows:
  \itemize{
    \item Changed function name from \code{moonphase} to \code{lunar.phase}.
    \item Changed input date to be in \code{\link[base]{Date}} format
          (as opposed to \code{\link[base]{POSIXct}}).
    \item Removed reliance on other R4MFCL functions.
    \item Changed name of primary input from \code{ptime} to \code{x}.
    \item Added optional \code{shift} term (in hours) relative to 12h UT.
    \item Added optional \code{name} term to control whether phase names
          as opposed to radians should be returned.
    \item Changed the documentation.
  }

  Where radians are returned:
  \itemize{
    \item 0 refers to the new moon
    \item \eqn{\pi/2} refers to the first quarter
    \item \eqn{\pi} refers to the full moon
    \item \eqn{3\pi/2} refers to the last quarter
  }

  Adapted originally from Stephen R. Schmitt: Sky & Telescope,
  Astronomical Computing, April 1994 and
  \url{https://web.archive.org/web/20140716104947/http://mysite.verizon.net/res148h4j/zenosamples/zs_lunarphasecalc.html},
  which references
  Jean Meeus, Astronomical Algorithms. Willmann-Bell, Inc. (1991) 429p.
}
\examples{
lunar.phase(as.Date("2013-05-06"))
}
\seealso{
\code{\link{lunar.4phases}}

\code{\link{lunar.8phases}}
}
\keyword{lunar}
\keyword{moon}
\keyword{phase}
