% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lslx-s3-interface.R
\name{plsem}
\alias{plsem}
\title{S3 interface for semi-confirmatory SEM via PL}
\usage{
plsem(
  model,
  data,
  penalty_method = "mcp",
  lambda_grid = "default",
  delta_grid = "default",
  numeric_variable,
  ordered_variable,
  weight_variable,
  auxiliary_variable,
  group_variable,
  reference_group,
  sample_cov,
  sample_mean,
  sample_size,
  sample_moment_acov,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{model}{A \code{character} with length one to represent the model specification.}

\item{data}{A \code{data.frame} of raw data. 
It must contains variables specified in \code{model} (and possibly the variables specified by \code{group_variable} and \code{weight_variable}).}

\item{penalty_method}{A \code{character} to specify the penalty method.
The current version supports \code{"none"}, \code{"lasso"}, \code{"ridge"}, \code{"elastic"}, and \code{"mcp"}.}

\item{lambda_grid}{A non-negative \code{numeric} to specify penalty levels for both \code{"lasso"} and \code{"mcp"}.
If it is set as \code{"default"}, its value will be generated automatically based on the variable scales.}

\item{delta_grid}{A non-negative \code{numeric} to specify the convexity level for \code{"mcp"}.
If it is set as \code{"default"}, its value will be generated automatically based on the variable scales.}

\item{numeric_variable}{A \code{character} to specify which response variables should be transfromed into \code{numeric}.}

\item{ordered_variable}{A \code{character} to specify which response variables should be transfromed into \code{ordered}.}

\item{weight_variable}{A \code{character} with length one to specify what variable is used for sampling weight.}

\item{auxiliary_variable}{A \code{character} to specify what variable(s) is used as auxiliary variable(s) for estimating saturated moments when missing data presents and two-step method is implemented. 
Auxiliary variable(s) must be numeric. If any categorical auxiliary is considered, please transform it into dummy variables before initialization.}

\item{group_variable}{A \code{character} with length one to specify what variable is used for labeling group.}

\item{reference_group}{A \code{character} with length one to specify which group is set as reference.}

\item{sample_cov}{A numeric \code{matrix} (single group case) or a \code{list} of numeric \code{matrix} (multi-group case) to represent sample covariance matrixs. It must have row and column names that match the variable names specified in \code{model}.}

\item{sample_mean}{A \code{numeric} (single group case) or a \code{list} of \code{numeric} (multi-group case) to represent sample mean vectors.}

\item{sample_size}{A \code{numeric} (single group case) with length one or a \code{list} of \code{numeric} (multi-group case) to represent the sample sizes.}

\item{sample_moment_acov}{A numeric \code{matrix} (single group case) or a \code{list} of numeric \code{matrix} (multi-group case) to represent asymptotic covariance for moments.}

\item{verbose}{A \code{logical} to specify whether messages made by \code{lslx} should be printed.}

\item{...}{Other arguments. For details, please see the documentation of \code{lslx}.}
}
\value{
A fitted \code{lslx} object
}
\description{
\code{plsem()} is an \code{S3} interface for obaining a fitted \code{lslx} object.
}
\examples{
## EXAMPLE: Semi-Confirmatory Factor Analysis with lavaan Style ##
# specify a factor analysis model with lavaan style
model_fa <- "visual  =~ x1 + x2 + x3
             textual =~ x4 + x5 + x6
             speed   =~ x7 + x8 + x9
             pen() * visual  =~ x4 + x5 + x6 + x7 + x8 + x9
             pen() * textual =~ x1 + x2 + x3 + x7 + x8 + x9
             pen() * speed   =~ x1 + x2 + x3 + x4 + x5 + x6
             visual  ~~ 1 * visual
             textual ~~ 1 * textual
             speed   ~~ 1 * speed"
             
# fit with mcp under specified penalty levels and convexity levels
lslx_fa <- plsem(model = model_fa, 
                 data = lavaan::HolzingerSwineford1939,
                 penalty_method = "mcp", 
                 lambda_grid = seq(.02, .60, .02), 
                 delta_grid = c(1.5, 3.0, Inf))

# summarize fitting result under the penalty level selected by 'bic'
summary(lslx_fa, selector = "bic")

}
