% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{getDesignEquiv}
\alias{getDesignEquiv}
\title{Power and Sample Size for a Generic Group Sequential Equivalence
Design}
\usage{
getDesignEquiv(
  beta = NA_real_,
  IMax = NA_real_,
  thetaLower = NA_real_,
  thetaUpper = NA_real_,
  theta = 0,
  kMax = 1L,
  informationRates = NA_real_,
  criticalValues = NA_real_,
  alpha = 0.05,
  typeAlphaSpending = "sfOF",
  parameterAlphaSpending = NA_real_,
  userAlphaSpending = NA_real_,
  spendingTime = NA_real_
)
}
\arguments{
\item{beta}{The type II error.}

\item{IMax}{The maximum information. Either \code{beta} or \code{IMax}
should be provided while the other one should be missing.}

\item{thetaLower}{The parameter value at the lower equivalence limit.}

\item{thetaUpper}{The parameter value at the upper equivalence limit.}

\item{theta}{The parameter value under the alternative hypothesis.}

\item{kMax}{The maximum number of stages.}

\item{informationRates}{The information rates. Fixed prior to the trial.
Defaults to \code{(1:kMax) / kMax} if left unspecified.}

\item{criticalValues}{Upper boundaries on the z-test statistic scale
for stopping for efficacy.}

\item{alpha}{The significance level for each of the two one-sided
tests, e.g., 0.05.}

\item{typeAlphaSpending}{The type of alpha spending. One of the following:
"OF" for O'Brien-Fleming boundaries, "P" for Pocock boundaries,
"WT" for Wang & Tsiatis boundaries, "sfOF" for O'Brien-Fleming type
spending function, "sfP" for Pocock type spending function,
"sfKD" for Kim & DeMets spending function, "sfHSD" for Hwang,
Shi & DeCani spending function, "user" for user defined spending,
and "none" for no early efficacy stopping. Defaults to "sfOF".}

\item{parameterAlphaSpending}{The parameter value for the alpha spending.
Corresponds to Delta for "WT", rho for "sfKD", and gamma for "sfHSD".}

\item{userAlphaSpending}{The user defined alpha spending. Cumulative alpha
spent up to each stage.}

\item{spendingTime}{A vector of length \code{kMax} for the error spending
time at each analysis. Defaults to missing, in which case, it is the
same as \code{informationRates}.}
}
\value{
An S3 class \code{designEquiv} object with three components:
\itemize{
\item \code{overallResults}: A data frame containing the following variables:
\itemize{
\item \code{overallReject}: The overall rejection probability.
\item \code{alpha}: The overall significance level.
\item \code{attainedAlphaH10}: The attained significance level under H10.
\item \code{attainedAlphaH20}: The attained significance level under H20.
\item \code{kMax}: The number of stages.
\item \code{thetaLower}: The parameter value at the lower equivalence
limit.
\item \code{thetaUpper}: The parameter value at the upper equivalence
limit.
\item \code{theta}: The parameter value under the alternative hypothesis.
\item \code{information}: The maximum information.
\item \code{expectedInformationH1}: The expected information under H1.
\item \code{expectedInformationH10}: The expected information under H10.
\item \code{expectedInformationH20}: The expected information under H20.
}
\item \code{byStageResults}: A data frame containing the following variables:
\itemize{
\item \code{informationRates}: The information rates.
\item \code{efficacyBounds}: The efficacy boundaries on the Z-scale for
each of the two one-sided tests.
\item \code{rejectPerStage}: The probability for efficacy stopping.
\item \code{cumulativeRejection}: The cumulative probability for efficacy
stopping.
\item \code{cumulativeAlphaSpent}: The cumulative alpha for each of
the two one-sided tests.
\item \code{cumulativeAttainedAlphaH10}: The cumulative probability for
efficacy stopping under H10.
\item \code{cumulativeAttainedAlphaH20}: The cumulative probability for
efficacy stopping under H20.
\item \code{efficacyThetaLower}: The efficacy boundaries on the
parameter scale for the one-sided null hypothesis at the
lower equivalence limit.
\item \code{efficacyThetaUpper}: The efficacy boundaries on the
parameter scale for the one-sided null hypothesis at the
upper equivalence limit.
\item \code{efficacyP}: The efficacy bounds on the p-value scale for
each of the two one-sided tests.
\item \code{information}: The cumulative information.
}
\item \code{settings}: A list containing the following components:
\itemize{
\item \code{typeAlphaSpending}: The type of alpha spending.
\item \code{parameterAlphaSpending}: The parameter value for alpha
spending.
\item \code{userAlphaSpending}: The user defined alpha spending.
\item \code{spendingTime}: The error spending time at each analysis.
}
}
}
\description{
Obtains the maximum information and stopping boundaries
for a generic group sequential equivalence design assuming a constant
treatment effect, or obtains the power given the maximum information
and stopping boundaries.
}
\details{
Consider the equivalence design with two one-sided hypotheses:
\deqn{H_{10}: \theta \leq \theta_{10},}
\deqn{H_{20}: \theta \geq \theta_{20}.}
We reject \eqn{H_{10}} at or before look \eqn{k} if
\deqn{Z_{1j} = (\hat{\theta}_j - \theta_{10})\sqrt{I_j}
\geq b_j}
for some \eqn{j=1,\ldots,k}, where \eqn{\{b_j:j=1,\ldots,K\}} are the
critical values associated with the specified alpha-spending function,
and \eqn{I_j} is the information for \eqn{\theta} (inverse variance of
\eqn{\hat{\theta}}) at the
\eqn{j}th look. For example,
for estimating the risk difference \eqn{\theta = \pi_1 - \pi_2},
\deqn{I_j = \left\{\frac{\pi_1 (1-\pi_1)}{n_{1j}} +
\frac{\pi_2(1-\pi_2)}{n_{2j}}\right\}^{-1}.}
It follows that
\deqn{(Z_{1j} \geq b_j) = (Z_j \geq b_j +
\theta_{10}\sqrt{I_j}),}
where \eqn{Z_j = \hat{\theta}_j \sqrt{I_j}}.

Similarly, we reject \eqn{H_{20}} at or before look \eqn{k} if
\deqn{Z_{2j} = (\hat{\theta}_j - \theta_{20})\sqrt{I_j}
\leq -b_j} for some \eqn{j=1,\ldots,k}. We have
\deqn{(Z_{2j} \leq -b_j) = (Z_j \leq - b_j +
\theta_{20}\sqrt{I_j}).}

Let \eqn{l_j = b_j + \theta_{10}\sqrt{I_j}},
and \eqn{u_j = -b_j + \theta_{20}\sqrt{I_j}}.
The cumulative probability to reject \eqn{H_0 = H_{10} \cup H_{20}} at
or before look \eqn{k} under the alternative hypothesis \eqn{H_1} is
given by
\deqn{P_\theta\left(\cup_{j=1}^{k} (Z_{1j} \geq b_j) \cap
\cup_{j=1}^{k} (Z_{2j} \leq -b_j)\right) = p_1 + p_2 - p_{12},}
where
\deqn{p_1 = P_\theta\left(\cup_{j=1}^{k} (Z_{1j} \geq b_j)\right)
= P_\theta\left(\cup_{j=1}^{k} (Z_j \geq l_j)\right),}
\deqn{p_2 = P_\theta\left(\cup_{j=1}^{k} (Z_{2j} \leq -b_j)\right)
= P_\theta\left(\cup_{j=1}^{k} (Z_j \leq u_j)\right),}
and
\deqn{p_{12} = P_\theta\left(\cup_{j=1}^{k} (Z_j \geq l_j) \cup
(Z_j \leq u_j)\right).}
Of note, both \eqn{p_1} and \eqn{p_2} can be evaluated using
one-sided exit probabilities for group sequential designs.
If there exists \eqn{j\leq k} such that \eqn{l_j \leq u_j}, then
\eqn{p_{12} = 1}. Otherwise, \eqn{p_{12}} can be evaluated using
two-sided exit probabilities for group sequential designs.

Since the equivalent hypothesis is tested using two one-sided tests,
the type I error is controlled. To evaluate the attained type I error
of the equivalence trial under \eqn{H_{10}} (or \eqn{H_{20}}),
we simply fix the control group parameters, update the active
treatment group parameters according to the null hypothesis, and
use the parameters in the power calculation outlined above.
}
\examples{

# Example 1: obtain the maximum information given power
(design1 <- getDesignEquiv(
  beta = 0.2, thetaLower = log(0.8), thetaUpper = log(1.25),
  kMax = 2, informationRates = c(0.5, 1),
  alpha = 0.05, typeAlphaSpending = "sfOF"))


# Example 2: obtain power given the maximum information
(design2 <- getDesignEquiv(
  IMax = 72.5, thetaLower = log(0.7), thetaUpper = -log(0.7),
  kMax = 3, informationRates = c(0.5, 0.75, 1),
  alpha = 0.05, typeAlphaSpending = "sfOF"))

}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
