% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rlognPareto.R
\name{rlognPareto}
\alias{rlognPareto}
\title{Simulation of the lognormal-Pareto spliced distribution}
\usage{
rlognPareto(n, sigma, xmin, alphapar)
}
\arguments{
\item{n}{positive integer: number of observations sampled.}

\item{sigma}{positive real: log-standard deviation of the truncated
lognormal distribution.}

\item{xmin}{positive real: scale parameter of the Pareto distribution.}

\item{alphapar}{positive real: shape parameterof the Pareto distribution.}
}
\value{
ysim (nreps x 1) vector: nreps random numbers from the
truncated lognormal-Pareto spliced distribution.
}
\description{
This function simulates the continuous and differentiable
version of the truncated lognormal-Pareto spliced distribution
proposed by Scollnik (2007).
}
\details{
See Scollnik (2007) for details.
}
\examples{
ysim <- rlognPareto(100,1,5,2)
}
\references{
{
\insertRef{scoll07}{lognGPD}
}
}
