% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{read_logs}
\alias{read_logs}
\title{Get log as \code{data.frame}}
\usage{
read_logs(logfile = get_logfile(), unsanitize = TRUE, last_first = FALSE)
}
\arguments{
\item{logfile}{Path to log file to read from.}

\item{unsanitize}{Should escaped special characters be unescaped?}

\item{last_first}{Should the last log entry be the first row of the data frame?}
}
\value{
A \code{data.frame}, with the columns as the fields in the log file.
}
\description{
Returns a \code{data.frame} containing all the logs in the provided \code{ndjson} log file.
}
\details{
\code{read_logs()} returns a \code{data.frame} with the empty character columns "timestamp", "log_lvl" and "log_msg"
if the log file has no entries.
}
\examples{
\dontrun{
  read_logs()

  read_logs(last_first = TRUE)
}
}
