% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/png.R
\name{inspectPng}
\alias{inspectPng}
\alias{print.lodermeta}
\title{Read metadata from a PNG file}
\usage{
inspectPng(file)

\method{print}{lodermeta}(x, ...)
}
\arguments{
\item{file}{A character string giving the file name to read from.}

\item{x}{An object of class \code{"lodermeta"}.}

\item{...}{Additional arguments (which are ignored).}
}
\value{
\code{inspectPng} returns a character vector of class
  \code{"lodermeta"}. The \code{print} method is called for its side-effect.
}
\description{
Inspect a PNG file, returning parsed metadata relating to it.
}
\details{
The LodePNG library is used to parse the PNG file at the specified path.
The result is a string like the input, but of class \code{"lodermeta"} and
with several attributes set describing the file's contents. There is a
\code{print} method for these objects.
}
\examples{
path <- system.file("extdata", "pngsuite", package="loder")
inspectPng(file.path(path, "basn6a08.png"))

}
\seealso{
\code{readPng} to read the pixel values.
}
