% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap.mru.R
\name{bootstrap.mru}
\alias{bootstrap.mru}
\title{Bootstrap procedure for Multinomial Restricted Unfolding}
\usage{
bootstrap.mru(object, Bsamples = 1000, myseed = 1)
}
\arguments{
\item{object}{An output object from mru}

\item{Bsamples}{Number of Bootstrap samples to take}

\item{myseed}{A seed number to make the bootstrap reproducible}
}
\value{
BBdf Bootstrap estimates of B

BVdf Bootstrap estimates of V
}
\description{
Bootstrap procedure for Multinomial Restricted Unfolding
}
\examples{
\dontrun{
data(dataExample_mru)
y = as.matrix(dataExample_mru[ , 1])
X = as.matrix(dataExample_mru[ , 2:6])
output = mru(y = y, X = X, S = 2)
boot.output = bootstrap.mru(output, Bsamples = 100)
plot(boot.output)
}

}
