% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/output-fxns.R
\name{steady_state}
\alias{steady_state}
\title{Estimate Steady State Biomass}
\usage{
steady_state(x = NULL, pars = NULL, model = NULL)
}
\arguments{
\item{x}{A \code{litfit} object. If provided, \code{pars} and \code{model} parameters are extracted from this object.}

\item{pars}{A numeric vector of parameters for the model. Only needed if \code{x} is not provided.}

\item{model}{A character string specifying the decomposition model. Must be one of the following:
"neg.exp", "weibull", "discrete.parallel", "discrete.series", or "cont.quality2".
Only needed if \code{x} is not provided.}
}
\value{
A named numeric value representing the estimated steady state biomass from the specified model.
}
\description{
Estimate Steady State Biomass
}
\details{
Computes the steady state biomass, as a proportion of the annual input, based on a given model fit or parameters.

Currently, the function supports a subset of decomposition models. New model support is planned
for future updates.
}
\examples{
# Example with litfit object
fit <- fit_litter(
  time = c(0,1,2,3,4,5,6),
  mass.remaining = c(1,0.9,1.01,0.4,0.6,0.2,0.01),
  model = 'neg.exp',
  iters = 250
)
steady_state(fit)

# Example with specific model and parameter values
steady_state(pars = c(6,2), model = "weibull")

}
\seealso{
\code{\link{fit_litter}} for generating \code{litfit} objects.
}
\author{
Will Cornwell
}
